﻿#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
This experiment was created using PsychoPy3 Experiment Builder (v2021.2.3),
    on 三月 26, 2024, at 21:08
If you publish work using this script the most relevant publication is:

    Peirce J, Gray JR, Simpson S, MacAskill M, Höchenberger R, Sogo H, Kastman E, Lindeløv JK. (2019) 
        PsychoPy2: Experiments in behavior made easy Behav Res 51: 195. 
        https://doi.org/10.3758/s13428-018-01193-y

"""

from __future__ import absolute_import, division

from psychopy import locale_setup
from psychopy import prefs
from psychopy import sound, gui, visual, core, data, event, logging, clock, colors
from psychopy.constants import (NOT_STARTED, STARTED, PLAYING, PAUSED,
                                STOPPED, FINISHED, PRESSED, RELEASED, FOREVER)

import numpy as np  # whole numpy lib is available, prepend 'np.'
from numpy import (sin, cos, tan, log, log10, pi, average,
                   sqrt, std, deg2rad, rad2deg, linspace, asarray)
from numpy.random import random, randint, normal, shuffle, choice as randchoice
import os  # handy system and path functions
import sys  # to get file system encoding

from psychopy.hardware import keyboard



# Ensure that relative paths start from the same directory as this script
_thisDir = os.path.dirname(os.path.abspath(__file__))
os.chdir(_thisDir)

# Store info about the experiment session
psychopyVersion = '2021.2.3'
expName = 'IAT'  # from the Builder filename that created this script
expInfo = {'': ''}
dlg = gui.DlgFromDict(dictionary=expInfo, sortKeys=False, title=expName)
if dlg.OK == False:
    core.quit()  # user pressed cancel
expInfo['date'] = data.getDateStr()  # add a simple timestamp
expInfo['expName'] = expName
expInfo['psychopyVersion'] = psychopyVersion

# Data file name stem = absolute path + name; later add .psyexp, .csv, .log, etc
filename = _thisDir + os.sep + 'data' + os.sep + u'psychopy_data_' + data.getDateStr()

# An ExperimentHandler isn't essential but helps with data saving
thisExp = data.ExperimentHandler(name=expName, version='',
    extraInfo=expInfo, runtimeInfo=None,
    originPath='C:\\Users\\王志皓\\Desktop\\maleIAT\\maleIAT\\IAT_lastrun.py',
    savePickle=True, saveWideText=True,
    dataFileName=filename)
# save a log file for detail verbose info
logFile = logging.LogFile(filename+'.log', level=logging.EXP)
logging.console.setLevel(logging.WARNING)  # this outputs to the screen, not a file

endExpNow = False  # flag for 'escape' or other condition => quit the exp
frameTolerance = 0.001  # how close to onset before 'same' frame

# Start Code - component code to be run after the window creation

# Setup the Window
win = visual.Window(
    size=[1707, 1067], fullscr=True, screen=0, 
    winType='pyglet', allowGUI=False, allowStencil=False,
    monitor='testMonitor', color=[1,1,1], colorSpace='rgb',
    blendMode='avg', useFBO=True, 
    units='height')
# store frame rate of monitor if we can measure it
expInfo['frameRate'] = win.getActualFrameRate()
if expInfo['frameRate'] != None:
    frameDur = 1.0 / round(expInfo['frameRate'])
else:
    frameDur = 1.0 / 60.0  # could not measure, so guess

# Setup eyetracking
ioDevice = ioConfig = ioSession = ioServer = eyetracker = None

# create a default keyboard (e.g. to check for escape)
defaultKeyboard = keyboard.Keyboard()

# Initialize components for Routine "instruction1"
instruction1Clock = core.Clock()
image1 = visual.ImageStim(
    win=win,
    name='image1', 
    image='pre1.png', mask=None,
    ori=0.0, pos=(0, 0), size=(1.5, 0.8392),
    color=[1,1,1], colorSpace='rgb', opacity=None,
    flipHoriz=False, flipVert=False,
    texRes=128.0, interpolate=True, depth=0.0)
key_resp = keyboard.Keyboard()

# Initialize components for Routine "insttruction123"
insttruction123Clock = core.Clock()
image222_2 = visual.ImageStim(
    win=win,
    name='image222_2', 
    image='pre2.png', mask=None,
    ori=0.0, pos=(0, 0), size=(1.5, 0.8365),
    color=[1,1,1], colorSpace='rgb', opacity=None,
    flipHoriz=False, flipVert=False,
    texRes=128.0, interpolate=True, depth=0.0)
key_resp_17 = keyboard.Keyboard()

# Initialize components for Routine "instruction213"
instruction213Clock = core.Clock()
image333_2 = visual.ImageStim(
    win=win,
    name='image333_2', 
    image='pre3.png', mask=None,
    ori=0.0, pos=(0, 0), size=(1.5, 0.9375),
    color=[1,1,1], colorSpace='rgb', opacity=None,
    flipHoriz=False, flipVert=False,
    texRes=128.0, interpolate=True, depth=0.0)
key_resp_18 = keyboard.Keyboard()

# Initialize components for Routine "instruction321"
instruction321Clock = core.Clock()
image999 = visual.ImageStim(
    win=win,
    name='image999', 
    image='pre4.png', mask=None,
    ori=0.0, pos=(0, 0), size=(1.5, 0.9375),
    color=[1,1,1], colorSpace='rgb', opacity=None,
    flipHoriz=False, flipVert=False,
    texRes=128.0, interpolate=True, depth=0.0)
key_resp_15 = keyboard.Keyboard()

# Initialize components for Routine "INS"
INSClock = core.Clock()
image = visual.ImageStim(
    win=win,
    name='image', 
    image='pre5.png', mask=None,
    ori=0.0, pos=(0, 0), size=(1.5, 0.9375),
    color=[1,1,1], colorSpace='rgb', opacity=None,
    flipHoriz=False, flipVert=False,
    texRes=128.0, interpolate=True, depth=0.0)
key_resp_19 = keyboard.Keyboard()

# Initialize components for Routine "ins5"
ins5Clock = core.Clock()
image_2 = visual.ImageStim(
    win=win,
    name='image_2', 
    image='pre6.png', mask=None,
    ori=0.0, pos=(0, 0), size=(1.5, 0.9375),
    color=[1,1,1], colorSpace='rgb', opacity=None,
    flipHoriz=False, flipVert=False,
    texRes=128.0, interpolate=True, depth=0.0)
key_resp_20 = keyboard.Keyboard()

# Initialize components for Routine "ins6"
ins6Clock = core.Clock()
image_3 = visual.ImageStim(
    win=win,
    name='image_3', 
    image='pre7.png', mask=None,
    ori=0.0, pos=(0, 0), size=(1.5, 0.9375),
    color=[1,1,1], colorSpace='rgb', opacity=None,
    flipHoriz=False, flipVert=False,
    texRes=128.0, interpolate=True, depth=0.0)
key_resp_21 = keyboard.Keyboard()

# Initialize components for Routine "instruction444"
instruction444Clock = core.Clock()
image_8 = visual.ImageStim(
    win=win,
    name='image_8', 
    image='block111.png', mask=None,
    ori=0.0, pos=(0, 0), size=(1.5, 0.9375),
    color=[1,1,1], colorSpace='rgb', opacity=None,
    flipHoriz=False, flipVert=False,
    texRes=128.0, interpolate=True, depth=0.0)
key_resp_16 = keyboard.Keyboard()

# Initialize components for Routine "trialsyundong1"
trialsyundong1Clock = core.Clock()
fixation = visual.TextStim(win=win, name='fixation',
    text='＋',
    font='Open Sans',
    pos=(0, 0), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=0.0);
text_3 = visual.TextStim(win=win, name='text_3',
    text='',
    font='Open Sans',
    pos=(0, 0), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=-1.0);
key_resp_2 = keyboard.Keyboard()
sportmale = visual.TextStim(win=win, name='sportmale',
    text='发型与人名一致（E）',
    font='Open Sans',
    pos=(-0.45, 0.35), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=-3.0);
sportfemale = visual.TextStim(win=win, name='sportfemale',
    text='发型与人名不一致 （I）',
    font='Open Sans',
    pos=(0.45, 0.35), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=-4.0);

# Initialize components for Routine "restart_trial1"
restart_trial1Clock = core.Clock()

# Initialize components for Routine "feedback1"
feedback1Clock = core.Clock()
feedback_text = ""
text1 = visual.TextStim(win=win, name='text1',
    text='',
    font='Open Sans',
    pos=(0, 0), height=0.1, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=-1.0);

# Initialize components for Routine "instruction2"
instruction2Clock = core.Clock()
image2 = visual.ImageStim(
    win=win,
    name='image2', 
    image='block222.png', mask=None,
    ori=0.0, pos=(0, 0), size=(1.5, 0.9375),
    color=[1,1,1], colorSpace='rgb', opacity=None,
    flipHoriz=False, flipVert=False,
    texRes=128.0, interpolate=True, depth=0.0)
key_resp_9 = keyboard.Keyboard()

# Initialize components for Routine "trialface1"
trialface1Clock = core.Clock()
fixation_2 = visual.TextStim(win=win, name='fixation_2',
    text='＋',
    font='Open Sans',
    pos=(0, 0), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=0.0);
stims2 = visual.TextStim(win=win, name='stims2',
    text='',
    font='Open Sans',
    pos=(0, 0), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=-1.0);
key_resp_3 = keyboard.Keyboard()
malename = visual.TextStim(win=win, name='malename',
    text='能力词（E）',
    font='Open Sans',
    pos=(-0.45, 0.35), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=-3.0);
femalename = visual.TextStim(win=win, name='femalename',
    text='热情词（I）',
    font='Open Sans',
    pos=(0.45, 0.35), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=-4.0);

# Initialize components for Routine "restart_trial2"
restart_trial2Clock = core.Clock()

# Initialize components for Routine "feedback2"
feedback2Clock = core.Clock()
feedback_text = ""
text2 = visual.TextStim(win=win, name='text2',
    text='',
    font='Open Sans',
    pos=(0, 0), height=0.1, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=-1.0);

# Initialize components for Routine "instruction3"
instruction3Clock = core.Clock()
image3 = visual.ImageStim(
    win=win,
    name='image3', 
    image='block333.png', mask=None,
    ori=0.0, pos=(0, 0), size=(1.5, 0.9375),
    color=[1,1,1], colorSpace='rgb', opacity=None,
    flipHoriz=False, flipVert=False,
    texRes=128.0, interpolate=True, depth=0.0)
key_resp_10 = keyboard.Keyboard()

# Initialize components for Routine "trialsprac1"
trialsprac1Clock = core.Clock()
fixation3 = visual.TextStim(win=win, name='fixation3',
    text='＋',
    font='Open Sans',
    pos=(0, 0), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=0.0);
stims3 = visual.TextStim(win=win, name='stims3',
    text='',
    font='Open Sans',
    pos=(0, 0), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=-1.0);
key_resp_4 = keyboard.Keyboard()
mm1 = visual.TextStim(win=win, name='mm1',
    text='发型与人名一致\n能力词',
    font='Open Sans',
    pos=(-0.45, 0.35), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=-3.0);
FF1 = visual.TextStim(win=win, name='FF1',
    text='发型与人名不一致\n热情词',
    font='Open Sans',
    pos=(0.45, 0.35), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=-4.0);

# Initialize components for Routine "restart_trial3"
restart_trial3Clock = core.Clock()

# Initialize components for Routine "feedback3"
feedback3Clock = core.Clock()
feedback_text = ""
text2_2 = visual.TextStim(win=win, name='text2_2',
    text='',
    font='Open Sans',
    pos=(0, 0), height=0.1, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=-1.0);

# Initialize components for Routine "instruction4"
instruction4Clock = core.Clock()
image4 = visual.ImageStim(
    win=win,
    name='image4', 
    image='block444.png', mask=None,
    ori=0.0, pos=(0, 0), size=(1.5, 0.9375),
    color=[1,1,1], colorSpace='rgb', opacity=None,
    flipHoriz=False, flipVert=False,
    texRes=128.0, interpolate=True, depth=0.0)
key_resp_11 = keyboard.Keyboard()

# Initialize components for Routine "trialszs1"
trialszs1Clock = core.Clock()
fixation4 = visual.TextStim(win=win, name='fixation4',
    text='＋',
    font='Open Sans',
    pos=(0, 0), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=0.0);
stims4 = visual.TextStim(win=win, name='stims4',
    text='',
    font='Open Sans',
    pos=(0, 0), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=-1.0);
key_resp_5 = keyboard.Keyboard()
mm1_2 = visual.TextStim(win=win, name='mm1_2',
    text='发型与人名一致\n能力词',
    font='Open Sans',
    pos=(-0.45, 0.35), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=-3.0);
FF1_2 = visual.TextStim(win=win, name='FF1_2',
    text='发型与人名不一致\n热情词',
    font='Open Sans',
    pos=(0.45, 0.35), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=-4.0);

# Initialize components for Routine "instroduction5"
instroduction5Clock = core.Clock()
image5 = visual.ImageStim(
    win=win,
    name='image5', 
    image='block555.png', mask=None,
    ori=0.0, pos=(0, 0), size=(1.5, 0.9375),
    color=[1,1,1], colorSpace='rgb', opacity=None,
    flipHoriz=False, flipVert=False,
    texRes=128.0, interpolate=True, depth=0.0)
key_resp_12 = keyboard.Keyboard()

# Initialize components for Routine "reialsyundong2"
reialsyundong2Clock = core.Clock()
fixation5 = visual.TextStim(win=win, name='fixation5',
    text='＋',
    font='Open Sans',
    pos=(0, 0), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=0.0);
stims5 = visual.TextStim(win=win, name='stims5',
    text='',
    font='Open Sans',
    pos=(0, 0), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=-1.0);
key_resp_6 = keyboard.Keyboard()
sportfemale2 = visual.TextStim(win=win, name='sportfemale2',
    text='发型与人名不一致',
    font='Open Sans',
    pos=(-0.45, 0.35), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=-3.0);
sportmale2 = visual.TextStim(win=win, name='sportmale2',
    text='发型与人名一致',
    font='Open Sans',
    pos=(0.45, 0.35), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=-4.0);

# Initialize components for Routine "restart_5"
restart_5Clock = core.Clock()

# Initialize components for Routine "feedback5"
feedback5Clock = core.Clock()
feedback_text = ""
text2_4 = visual.TextStim(win=win, name='text2_4',
    text='',
    font='Open Sans',
    pos=(0, 0), height=0.1, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=-1.0);

# Initialize components for Routine "instruction6"
instruction6Clock = core.Clock()
image6 = visual.ImageStim(
    win=win,
    name='image6', 
    image='block666.png', mask=None,
    ori=0.0, pos=(0, 0), size=(1.5, 0.9375),
    color=[1,1,1], colorSpace='rgb', opacity=None,
    flipHoriz=False, flipVert=False,
    texRes=128.0, interpolate=True, depth=0.0)
key_resp_13 = keyboard.Keyboard()

# Initialize components for Routine "trialspr2"
trialspr2Clock = core.Clock()
fixation6 = visual.TextStim(win=win, name='fixation6',
    text='＋',
    font='Open Sans',
    pos=(0, 0), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=0.0);
stims6 = visual.TextStim(win=win, name='stims6',
    text='',
    font='Open Sans',
    pos=(0, 0), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=-1.0);
key_resp_7 = keyboard.Keyboard()
FM = visual.TextStim(win=win, name='FM',
    text='发型与人名不一致\n能力词',
    font='Open Sans',
    pos=(-0.45, 0.35), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=-3.0);
MF = visual.TextStim(win=win, name='MF',
    text='发型与人名一致\n热情词',
    font='Open Sans',
    pos=(0.45, 0.35), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=-4.0);

# Initialize components for Routine "restart_trial6"
restart_trial6Clock = core.Clock()

# Initialize components for Routine "feedback6"
feedback6Clock = core.Clock()
feedback_text = ""
text2_5 = visual.TextStim(win=win, name='text2_5',
    text='',
    font='Open Sans',
    pos=(0, 0), height=0.1, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=-1.0);

# Initialize components for Routine "instruction7"
instruction7Clock = core.Clock()
image7 = visual.ImageStim(
    win=win,
    name='image7', 
    image='block777.png', mask=None,
    ori=0.0, pos=(0, 0), size=(1.5, 0.9375),
    color=[1,1,1], colorSpace='rgb', opacity=None,
    flipHoriz=False, flipVert=False,
    texRes=128.0, interpolate=True, depth=0.0)
key_resp_14 = keyboard.Keyboard()

# Initialize components for Routine "trialszs2"
trialszs2Clock = core.Clock()
fixation7 = visual.TextStim(win=win, name='fixation7',
    text='＋',
    font='Open Sans',
    pos=(0, 0), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=0.0);
stims7 = visual.TextStim(win=win, name='stims7',
    text='',
    font='Open Sans',
    pos=(0, 0), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=-1.0);
key_resp_8 = keyboard.Keyboard()
FM_2 = visual.TextStim(win=win, name='FM_2',
    text='发型与人名不一致\n能力词',
    font='Open Sans',
    pos=(-0.45, 0.35), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=-3.0);
MF_2 = visual.TextStim(win=win, name='MF_2',
    text='发型与人名一致\n热情词',
    font='Open Sans',
    pos=(0.45, 0.35), height=0.05, wrapWidth=None, ori=0.0, 
    color='black', colorSpace='rgb', opacity=None, 
    languageStyle='LTR',
    depth=-4.0);

# Initialize components for Routine "thanks"
thanksClock = core.Clock()
imageend = visual.ImageStim(
    win=win,
    name='imageend', 
    image='end.png', mask=None,
    ori=0.0, pos=(0, 0), size=(1.5, 0.9375),
    color=[1,1,1], colorSpace='rgb', opacity=None,
    flipHoriz=False, flipVert=False,
    texRes=128.0, interpolate=True, depth=0.0)

# Create some handy timers
globalClock = core.Clock()  # to track the time since experiment started
routineTimer = core.CountdownTimer()  # to track time remaining of each (non-slip) routine 

# ------Prepare to start Routine "instruction1"-------
continueRoutine = True
# update component parameters for each repeat
key_resp.keys = []
key_resp.rt = []
_key_resp_allKeys = []
# keep track of which components have finished
instruction1Components = [image1, key_resp]
for thisComponent in instruction1Components:
    thisComponent.tStart = None
    thisComponent.tStop = None
    thisComponent.tStartRefresh = None
    thisComponent.tStopRefresh = None
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED
# reset timers
t = 0
_timeToFirstFrame = win.getFutureFlipTime(clock="now")
instruction1Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
frameN = -1

# -------Run Routine "instruction1"-------
while continueRoutine:
    # get current time
    t = instruction1Clock.getTime()
    tThisFlip = win.getFutureFlipTime(clock=instruction1Clock)
    tThisFlipGlobal = win.getFutureFlipTime(clock=None)
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    # *image1* updates
    if image1.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        image1.frameNStart = frameN  # exact frame index
        image1.tStart = t  # local t and not account for scr refresh
        image1.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(image1, 'tStartRefresh')  # time at next scr refresh
        image1.setAutoDraw(True)
    
    # *key_resp* updates
    waitOnFlip = False
    if key_resp.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        key_resp.frameNStart = frameN  # exact frame index
        key_resp.tStart = t  # local t and not account for scr refresh
        key_resp.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(key_resp, 'tStartRefresh')  # time at next scr refresh
        key_resp.status = STARTED
        # keyboard checking is just starting
        waitOnFlip = True
        win.callOnFlip(key_resp.clock.reset)  # t=0 on next screen flip
        win.callOnFlip(key_resp.clearEvents, eventType='keyboard')  # clear events on next screen flip
    if key_resp.status == STARTED and not waitOnFlip:
        theseKeys = key_resp.getKeys(keyList=['space'], waitRelease=False)
        _key_resp_allKeys.extend(theseKeys)
        if len(_key_resp_allKeys):
            key_resp.keys = _key_resp_allKeys[-1].name  # just the last key pressed
            key_resp.rt = _key_resp_allKeys[-1].rt
            # a response ends the routine
            continueRoutine = False
    
    # check for quit (typically the Esc key)
    if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
        core.quit()
    
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in instruction1Components:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # refresh the screen
    if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
        win.flip()

# -------Ending Routine "instruction1"-------
for thisComponent in instruction1Components:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)
thisExp.addData('image1.started', image1.tStartRefresh)
thisExp.addData('image1.stopped', image1.tStopRefresh)
# check responses
if key_resp.keys in ['', [], None]:  # No response was made
    key_resp.keys = None
thisExp.addData('key_resp.keys',key_resp.keys)
if key_resp.keys != None:  # we had a response
    thisExp.addData('key_resp.rt', key_resp.rt)
thisExp.addData('key_resp.started', key_resp.tStartRefresh)
thisExp.addData('key_resp.stopped', key_resp.tStopRefresh)
thisExp.nextEntry()
# the Routine "instruction1" was not non-slip safe, so reset the non-slip timer
routineTimer.reset()

# ------Prepare to start Routine "insttruction123"-------
continueRoutine = True
# update component parameters for each repeat
key_resp_17.keys = []
key_resp_17.rt = []
_key_resp_17_allKeys = []
# keep track of which components have finished
insttruction123Components = [image222_2, key_resp_17]
for thisComponent in insttruction123Components:
    thisComponent.tStart = None
    thisComponent.tStop = None
    thisComponent.tStartRefresh = None
    thisComponent.tStopRefresh = None
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED
# reset timers
t = 0
_timeToFirstFrame = win.getFutureFlipTime(clock="now")
insttruction123Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
frameN = -1

# -------Run Routine "insttruction123"-------
while continueRoutine:
    # get current time
    t = insttruction123Clock.getTime()
    tThisFlip = win.getFutureFlipTime(clock=insttruction123Clock)
    tThisFlipGlobal = win.getFutureFlipTime(clock=None)
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    # *image222_2* updates
    if image222_2.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        image222_2.frameNStart = frameN  # exact frame index
        image222_2.tStart = t  # local t and not account for scr refresh
        image222_2.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(image222_2, 'tStartRefresh')  # time at next scr refresh
        image222_2.setAutoDraw(True)
    
    # *key_resp_17* updates
    waitOnFlip = False
    if key_resp_17.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        key_resp_17.frameNStart = frameN  # exact frame index
        key_resp_17.tStart = t  # local t and not account for scr refresh
        key_resp_17.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(key_resp_17, 'tStartRefresh')  # time at next scr refresh
        key_resp_17.status = STARTED
        # keyboard checking is just starting
        waitOnFlip = True
        win.callOnFlip(key_resp_17.clock.reset)  # t=0 on next screen flip
        win.callOnFlip(key_resp_17.clearEvents, eventType='keyboard')  # clear events on next screen flip
    if key_resp_17.status == STARTED and not waitOnFlip:
        theseKeys = key_resp_17.getKeys(keyList=['space'], waitRelease=False)
        _key_resp_17_allKeys.extend(theseKeys)
        if len(_key_resp_17_allKeys):
            key_resp_17.keys = _key_resp_17_allKeys[-1].name  # just the last key pressed
            key_resp_17.rt = _key_resp_17_allKeys[-1].rt
            # a response ends the routine
            continueRoutine = False
    
    # check for quit (typically the Esc key)
    if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
        core.quit()
    
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in insttruction123Components:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # refresh the screen
    if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
        win.flip()

# -------Ending Routine "insttruction123"-------
for thisComponent in insttruction123Components:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)
thisExp.addData('image222_2.started', image222_2.tStartRefresh)
thisExp.addData('image222_2.stopped', image222_2.tStopRefresh)
# check responses
if key_resp_17.keys in ['', [], None]:  # No response was made
    key_resp_17.keys = None
thisExp.addData('key_resp_17.keys',key_resp_17.keys)
if key_resp_17.keys != None:  # we had a response
    thisExp.addData('key_resp_17.rt', key_resp_17.rt)
thisExp.addData('key_resp_17.started', key_resp_17.tStartRefresh)
thisExp.addData('key_resp_17.stopped', key_resp_17.tStopRefresh)
thisExp.nextEntry()
# the Routine "insttruction123" was not non-slip safe, so reset the non-slip timer
routineTimer.reset()

# ------Prepare to start Routine "instruction213"-------
continueRoutine = True
# update component parameters for each repeat
key_resp_18.keys = []
key_resp_18.rt = []
_key_resp_18_allKeys = []
# keep track of which components have finished
instruction213Components = [image333_2, key_resp_18]
for thisComponent in instruction213Components:
    thisComponent.tStart = None
    thisComponent.tStop = None
    thisComponent.tStartRefresh = None
    thisComponent.tStopRefresh = None
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED
# reset timers
t = 0
_timeToFirstFrame = win.getFutureFlipTime(clock="now")
instruction213Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
frameN = -1

# -------Run Routine "instruction213"-------
while continueRoutine:
    # get current time
    t = instruction213Clock.getTime()
    tThisFlip = win.getFutureFlipTime(clock=instruction213Clock)
    tThisFlipGlobal = win.getFutureFlipTime(clock=None)
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    # *image333_2* updates
    if image333_2.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        image333_2.frameNStart = frameN  # exact frame index
        image333_2.tStart = t  # local t and not account for scr refresh
        image333_2.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(image333_2, 'tStartRefresh')  # time at next scr refresh
        image333_2.setAutoDraw(True)
    
    # *key_resp_18* updates
    waitOnFlip = False
    if key_resp_18.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        key_resp_18.frameNStart = frameN  # exact frame index
        key_resp_18.tStart = t  # local t and not account for scr refresh
        key_resp_18.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(key_resp_18, 'tStartRefresh')  # time at next scr refresh
        key_resp_18.status = STARTED
        # keyboard checking is just starting
        waitOnFlip = True
        win.callOnFlip(key_resp_18.clock.reset)  # t=0 on next screen flip
        win.callOnFlip(key_resp_18.clearEvents, eventType='keyboard')  # clear events on next screen flip
    if key_resp_18.status == STARTED and not waitOnFlip:
        theseKeys = key_resp_18.getKeys(keyList=['space'], waitRelease=False)
        _key_resp_18_allKeys.extend(theseKeys)
        if len(_key_resp_18_allKeys):
            key_resp_18.keys = _key_resp_18_allKeys[-1].name  # just the last key pressed
            key_resp_18.rt = _key_resp_18_allKeys[-1].rt
            # a response ends the routine
            continueRoutine = False
    
    # check for quit (typically the Esc key)
    if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
        core.quit()
    
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in instruction213Components:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # refresh the screen
    if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
        win.flip()

# -------Ending Routine "instruction213"-------
for thisComponent in instruction213Components:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)
thisExp.addData('image333_2.started', image333_2.tStartRefresh)
thisExp.addData('image333_2.stopped', image333_2.tStopRefresh)
# check responses
if key_resp_18.keys in ['', [], None]:  # No response was made
    key_resp_18.keys = None
thisExp.addData('key_resp_18.keys',key_resp_18.keys)
if key_resp_18.keys != None:  # we had a response
    thisExp.addData('key_resp_18.rt', key_resp_18.rt)
thisExp.addData('key_resp_18.started', key_resp_18.tStartRefresh)
thisExp.addData('key_resp_18.stopped', key_resp_18.tStopRefresh)
thisExp.nextEntry()
# the Routine "instruction213" was not non-slip safe, so reset the non-slip timer
routineTimer.reset()

# ------Prepare to start Routine "instruction321"-------
continueRoutine = True
# update component parameters for each repeat
key_resp_15.keys = []
key_resp_15.rt = []
_key_resp_15_allKeys = []
# keep track of which components have finished
instruction321Components = [image999, key_resp_15]
for thisComponent in instruction321Components:
    thisComponent.tStart = None
    thisComponent.tStop = None
    thisComponent.tStartRefresh = None
    thisComponent.tStopRefresh = None
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED
# reset timers
t = 0
_timeToFirstFrame = win.getFutureFlipTime(clock="now")
instruction321Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
frameN = -1

# -------Run Routine "instruction321"-------
while continueRoutine:
    # get current time
    t = instruction321Clock.getTime()
    tThisFlip = win.getFutureFlipTime(clock=instruction321Clock)
    tThisFlipGlobal = win.getFutureFlipTime(clock=None)
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    # *image999* updates
    if image999.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        image999.frameNStart = frameN  # exact frame index
        image999.tStart = t  # local t and not account for scr refresh
        image999.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(image999, 'tStartRefresh')  # time at next scr refresh
        image999.setAutoDraw(True)
    
    # *key_resp_15* updates
    waitOnFlip = False
    if key_resp_15.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        key_resp_15.frameNStart = frameN  # exact frame index
        key_resp_15.tStart = t  # local t and not account for scr refresh
        key_resp_15.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(key_resp_15, 'tStartRefresh')  # time at next scr refresh
        key_resp_15.status = STARTED
        # keyboard checking is just starting
        waitOnFlip = True
        win.callOnFlip(key_resp_15.clock.reset)  # t=0 on next screen flip
        win.callOnFlip(key_resp_15.clearEvents, eventType='keyboard')  # clear events on next screen flip
    if key_resp_15.status == STARTED and not waitOnFlip:
        theseKeys = key_resp_15.getKeys(keyList=['space'], waitRelease=False)
        _key_resp_15_allKeys.extend(theseKeys)
        if len(_key_resp_15_allKeys):
            key_resp_15.keys = _key_resp_15_allKeys[-1].name  # just the last key pressed
            key_resp_15.rt = _key_resp_15_allKeys[-1].rt
            # a response ends the routine
            continueRoutine = False
    
    # check for quit (typically the Esc key)
    if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
        core.quit()
    
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in instruction321Components:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # refresh the screen
    if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
        win.flip()

# -------Ending Routine "instruction321"-------
for thisComponent in instruction321Components:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)
thisExp.addData('image999.started', image999.tStartRefresh)
thisExp.addData('image999.stopped', image999.tStopRefresh)
# check responses
if key_resp_15.keys in ['', [], None]:  # No response was made
    key_resp_15.keys = None
thisExp.addData('key_resp_15.keys',key_resp_15.keys)
if key_resp_15.keys != None:  # we had a response
    thisExp.addData('key_resp_15.rt', key_resp_15.rt)
thisExp.addData('key_resp_15.started', key_resp_15.tStartRefresh)
thisExp.addData('key_resp_15.stopped', key_resp_15.tStopRefresh)
thisExp.nextEntry()
# the Routine "instruction321" was not non-slip safe, so reset the non-slip timer
routineTimer.reset()

# ------Prepare to start Routine "INS"-------
continueRoutine = True
# update component parameters for each repeat
key_resp_19.keys = []
key_resp_19.rt = []
_key_resp_19_allKeys = []
# keep track of which components have finished
INSComponents = [image, key_resp_19]
for thisComponent in INSComponents:
    thisComponent.tStart = None
    thisComponent.tStop = None
    thisComponent.tStartRefresh = None
    thisComponent.tStopRefresh = None
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED
# reset timers
t = 0
_timeToFirstFrame = win.getFutureFlipTime(clock="now")
INSClock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
frameN = -1

# -------Run Routine "INS"-------
while continueRoutine:
    # get current time
    t = INSClock.getTime()
    tThisFlip = win.getFutureFlipTime(clock=INSClock)
    tThisFlipGlobal = win.getFutureFlipTime(clock=None)
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    # *image* updates
    if image.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        image.frameNStart = frameN  # exact frame index
        image.tStart = t  # local t and not account for scr refresh
        image.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(image, 'tStartRefresh')  # time at next scr refresh
        image.setAutoDraw(True)
    
    # *key_resp_19* updates
    waitOnFlip = False
    if key_resp_19.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        key_resp_19.frameNStart = frameN  # exact frame index
        key_resp_19.tStart = t  # local t and not account for scr refresh
        key_resp_19.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(key_resp_19, 'tStartRefresh')  # time at next scr refresh
        key_resp_19.status = STARTED
        # keyboard checking is just starting
        waitOnFlip = True
        win.callOnFlip(key_resp_19.clock.reset)  # t=0 on next screen flip
        win.callOnFlip(key_resp_19.clearEvents, eventType='keyboard')  # clear events on next screen flip
    if key_resp_19.status == STARTED and not waitOnFlip:
        theseKeys = key_resp_19.getKeys(keyList=['space'], waitRelease=False)
        _key_resp_19_allKeys.extend(theseKeys)
        if len(_key_resp_19_allKeys):
            key_resp_19.keys = _key_resp_19_allKeys[-1].name  # just the last key pressed
            key_resp_19.rt = _key_resp_19_allKeys[-1].rt
            # a response ends the routine
            continueRoutine = False
    
    # check for quit (typically the Esc key)
    if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
        core.quit()
    
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in INSComponents:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # refresh the screen
    if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
        win.flip()

# -------Ending Routine "INS"-------
for thisComponent in INSComponents:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)
thisExp.addData('image.started', image.tStartRefresh)
thisExp.addData('image.stopped', image.tStopRefresh)
# check responses
if key_resp_19.keys in ['', [], None]:  # No response was made
    key_resp_19.keys = None
thisExp.addData('key_resp_19.keys',key_resp_19.keys)
if key_resp_19.keys != None:  # we had a response
    thisExp.addData('key_resp_19.rt', key_resp_19.rt)
thisExp.addData('key_resp_19.started', key_resp_19.tStartRefresh)
thisExp.addData('key_resp_19.stopped', key_resp_19.tStopRefresh)
thisExp.nextEntry()
# the Routine "INS" was not non-slip safe, so reset the non-slip timer
routineTimer.reset()

# ------Prepare to start Routine "ins5"-------
continueRoutine = True
# update component parameters for each repeat
key_resp_20.keys = []
key_resp_20.rt = []
_key_resp_20_allKeys = []
# keep track of which components have finished
ins5Components = [image_2, key_resp_20]
for thisComponent in ins5Components:
    thisComponent.tStart = None
    thisComponent.tStop = None
    thisComponent.tStartRefresh = None
    thisComponent.tStopRefresh = None
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED
# reset timers
t = 0
_timeToFirstFrame = win.getFutureFlipTime(clock="now")
ins5Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
frameN = -1

# -------Run Routine "ins5"-------
while continueRoutine:
    # get current time
    t = ins5Clock.getTime()
    tThisFlip = win.getFutureFlipTime(clock=ins5Clock)
    tThisFlipGlobal = win.getFutureFlipTime(clock=None)
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    # *image_2* updates
    if image_2.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        image_2.frameNStart = frameN  # exact frame index
        image_2.tStart = t  # local t and not account for scr refresh
        image_2.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(image_2, 'tStartRefresh')  # time at next scr refresh
        image_2.setAutoDraw(True)
    
    # *key_resp_20* updates
    waitOnFlip = False
    if key_resp_20.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        key_resp_20.frameNStart = frameN  # exact frame index
        key_resp_20.tStart = t  # local t and not account for scr refresh
        key_resp_20.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(key_resp_20, 'tStartRefresh')  # time at next scr refresh
        key_resp_20.status = STARTED
        # keyboard checking is just starting
        waitOnFlip = True
        win.callOnFlip(key_resp_20.clock.reset)  # t=0 on next screen flip
        win.callOnFlip(key_resp_20.clearEvents, eventType='keyboard')  # clear events on next screen flip
    if key_resp_20.status == STARTED and not waitOnFlip:
        theseKeys = key_resp_20.getKeys(keyList=['space'], waitRelease=False)
        _key_resp_20_allKeys.extend(theseKeys)
        if len(_key_resp_20_allKeys):
            key_resp_20.keys = _key_resp_20_allKeys[-1].name  # just the last key pressed
            key_resp_20.rt = _key_resp_20_allKeys[-1].rt
            # a response ends the routine
            continueRoutine = False
    
    # check for quit (typically the Esc key)
    if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
        core.quit()
    
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in ins5Components:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # refresh the screen
    if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
        win.flip()

# -------Ending Routine "ins5"-------
for thisComponent in ins5Components:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)
thisExp.addData('image_2.started', image_2.tStartRefresh)
thisExp.addData('image_2.stopped', image_2.tStopRefresh)
# check responses
if key_resp_20.keys in ['', [], None]:  # No response was made
    key_resp_20.keys = None
thisExp.addData('key_resp_20.keys',key_resp_20.keys)
if key_resp_20.keys != None:  # we had a response
    thisExp.addData('key_resp_20.rt', key_resp_20.rt)
thisExp.addData('key_resp_20.started', key_resp_20.tStartRefresh)
thisExp.addData('key_resp_20.stopped', key_resp_20.tStopRefresh)
thisExp.nextEntry()
# the Routine "ins5" was not non-slip safe, so reset the non-slip timer
routineTimer.reset()

# ------Prepare to start Routine "ins6"-------
continueRoutine = True
# update component parameters for each repeat
key_resp_21.keys = []
key_resp_21.rt = []
_key_resp_21_allKeys = []
# keep track of which components have finished
ins6Components = [image_3, key_resp_21]
for thisComponent in ins6Components:
    thisComponent.tStart = None
    thisComponent.tStop = None
    thisComponent.tStartRefresh = None
    thisComponent.tStopRefresh = None
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED
# reset timers
t = 0
_timeToFirstFrame = win.getFutureFlipTime(clock="now")
ins6Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
frameN = -1

# -------Run Routine "ins6"-------
while continueRoutine:
    # get current time
    t = ins6Clock.getTime()
    tThisFlip = win.getFutureFlipTime(clock=ins6Clock)
    tThisFlipGlobal = win.getFutureFlipTime(clock=None)
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    # *image_3* updates
    if image_3.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        image_3.frameNStart = frameN  # exact frame index
        image_3.tStart = t  # local t and not account for scr refresh
        image_3.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(image_3, 'tStartRefresh')  # time at next scr refresh
        image_3.setAutoDraw(True)
    
    # *key_resp_21* updates
    waitOnFlip = False
    if key_resp_21.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        key_resp_21.frameNStart = frameN  # exact frame index
        key_resp_21.tStart = t  # local t and not account for scr refresh
        key_resp_21.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(key_resp_21, 'tStartRefresh')  # time at next scr refresh
        key_resp_21.status = STARTED
        # keyboard checking is just starting
        waitOnFlip = True
        win.callOnFlip(key_resp_21.clock.reset)  # t=0 on next screen flip
        win.callOnFlip(key_resp_21.clearEvents, eventType='keyboard')  # clear events on next screen flip
    if key_resp_21.status == STARTED and not waitOnFlip:
        theseKeys = key_resp_21.getKeys(keyList=['space'], waitRelease=False)
        _key_resp_21_allKeys.extend(theseKeys)
        if len(_key_resp_21_allKeys):
            key_resp_21.keys = _key_resp_21_allKeys[-1].name  # just the last key pressed
            key_resp_21.rt = _key_resp_21_allKeys[-1].rt
            # a response ends the routine
            continueRoutine = False
    
    # check for quit (typically the Esc key)
    if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
        core.quit()
    
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in ins6Components:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # refresh the screen
    if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
        win.flip()

# -------Ending Routine "ins6"-------
for thisComponent in ins6Components:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)
thisExp.addData('image_3.started', image_3.tStartRefresh)
thisExp.addData('image_3.stopped', image_3.tStopRefresh)
# check responses
if key_resp_21.keys in ['', [], None]:  # No response was made
    key_resp_21.keys = None
thisExp.addData('key_resp_21.keys',key_resp_21.keys)
if key_resp_21.keys != None:  # we had a response
    thisExp.addData('key_resp_21.rt', key_resp_21.rt)
thisExp.addData('key_resp_21.started', key_resp_21.tStartRefresh)
thisExp.addData('key_resp_21.stopped', key_resp_21.tStopRefresh)
thisExp.nextEntry()
# the Routine "ins6" was not non-slip safe, so reset the non-slip timer
routineTimer.reset()

# ------Prepare to start Routine "instruction444"-------
continueRoutine = True
# update component parameters for each repeat
key_resp_16.keys = []
key_resp_16.rt = []
_key_resp_16_allKeys = []
# keep track of which components have finished
instruction444Components = [image_8, key_resp_16]
for thisComponent in instruction444Components:
    thisComponent.tStart = None
    thisComponent.tStop = None
    thisComponent.tStartRefresh = None
    thisComponent.tStopRefresh = None
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED
# reset timers
t = 0
_timeToFirstFrame = win.getFutureFlipTime(clock="now")
instruction444Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
frameN = -1

# -------Run Routine "instruction444"-------
while continueRoutine:
    # get current time
    t = instruction444Clock.getTime()
    tThisFlip = win.getFutureFlipTime(clock=instruction444Clock)
    tThisFlipGlobal = win.getFutureFlipTime(clock=None)
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    # *image_8* updates
    if image_8.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        image_8.frameNStart = frameN  # exact frame index
        image_8.tStart = t  # local t and not account for scr refresh
        image_8.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(image_8, 'tStartRefresh')  # time at next scr refresh
        image_8.setAutoDraw(True)
    
    # *key_resp_16* updates
    waitOnFlip = False
    if key_resp_16.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        key_resp_16.frameNStart = frameN  # exact frame index
        key_resp_16.tStart = t  # local t and not account for scr refresh
        key_resp_16.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(key_resp_16, 'tStartRefresh')  # time at next scr refresh
        key_resp_16.status = STARTED
        # keyboard checking is just starting
        waitOnFlip = True
        win.callOnFlip(key_resp_16.clock.reset)  # t=0 on next screen flip
        win.callOnFlip(key_resp_16.clearEvents, eventType='keyboard')  # clear events on next screen flip
    if key_resp_16.status == STARTED and not waitOnFlip:
        theseKeys = key_resp_16.getKeys(keyList=['space'], waitRelease=False)
        _key_resp_16_allKeys.extend(theseKeys)
        if len(_key_resp_16_allKeys):
            key_resp_16.keys = _key_resp_16_allKeys[-1].name  # just the last key pressed
            key_resp_16.rt = _key_resp_16_allKeys[-1].rt
            # a response ends the routine
            continueRoutine = False
    
    # check for quit (typically the Esc key)
    if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
        core.quit()
    
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in instruction444Components:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # refresh the screen
    if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
        win.flip()

# -------Ending Routine "instruction444"-------
for thisComponent in instruction444Components:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)
thisExp.addData('image_8.started', image_8.tStartRefresh)
thisExp.addData('image_8.stopped', image_8.tStopRefresh)
# check responses
if key_resp_16.keys in ['', [], None]:  # No response was made
    key_resp_16.keys = None
thisExp.addData('key_resp_16.keys',key_resp_16.keys)
if key_resp_16.keys != None:  # we had a response
    thisExp.addData('key_resp_16.rt', key_resp_16.rt)
thisExp.addData('key_resp_16.started', key_resp_16.tStartRefresh)
thisExp.addData('key_resp_16.stopped', key_resp_16.tStopRefresh)
thisExp.nextEntry()
# the Routine "instruction444" was not non-slip safe, so reset the non-slip timer
routineTimer.reset()

# set up handler to look after randomisation of conditions etc
loop1 = data.TrialHandler(nReps=2.0, method='random', 
    extraInfo=expInfo, originPath=-1,
    trialList=data.importConditions('IAT_block1.xlsx'),
    seed=None, name='loop1')
thisExp.addLoop(loop1)  # add the loop to the experiment
thisLoop1 = loop1.trialList[0]  # so we can initialise stimuli with some values
# abbreviate parameter names if possible (e.g. rgb = thisLoop1.rgb)
if thisLoop1 != None:
    for paramName in thisLoop1:
        exec('{} = thisLoop1[paramName]'.format(paramName))

for thisLoop1 in loop1:
    currentLoop = loop1
    # abbreviate parameter names if possible (e.g. rgb = thisLoop1.rgb)
    if thisLoop1 != None:
        for paramName in thisLoop1:
            exec('{} = thisLoop1[paramName]'.format(paramName))
    
    # set up handler to look after randomisation of conditions etc
    repeatLoop1 = data.TrialHandler(nReps=5.0, method='random', 
        extraInfo=expInfo, originPath=-1,
        trialList=[None],
        seed=None, name='repeatLoop1')
    thisExp.addLoop(repeatLoop1)  # add the loop to the experiment
    thisRepeatLoop1 = repeatLoop1.trialList[0]  # so we can initialise stimuli with some values
    # abbreviate parameter names if possible (e.g. rgb = thisRepeatLoop1.rgb)
    if thisRepeatLoop1 != None:
        for paramName in thisRepeatLoop1:
            exec('{} = thisRepeatLoop1[paramName]'.format(paramName))
    
    for thisRepeatLoop1 in repeatLoop1:
        currentLoop = repeatLoop1
        # abbreviate parameter names if possible (e.g. rgb = thisRepeatLoop1.rgb)
        if thisRepeatLoop1 != None:
            for paramName in thisRepeatLoop1:
                exec('{} = thisRepeatLoop1[paramName]'.format(paramName))
        
        # ------Prepare to start Routine "trialsyundong1"-------
        continueRoutine = True
        # update component parameters for each repeat
        text_3.setText(stims11)
        key_resp_2.keys = []
        key_resp_2.rt = []
        _key_resp_2_allKeys = []
        # keep track of which components have finished
        trialsyundong1Components = [fixation, text_3, key_resp_2, sportmale, sportfemale]
        for thisComponent in trialsyundong1Components:
            thisComponent.tStart = None
            thisComponent.tStop = None
            thisComponent.tStartRefresh = None
            thisComponent.tStopRefresh = None
            if hasattr(thisComponent, 'status'):
                thisComponent.status = NOT_STARTED
        # reset timers
        t = 0
        _timeToFirstFrame = win.getFutureFlipTime(clock="now")
        trialsyundong1Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
        frameN = -1
        
        # -------Run Routine "trialsyundong1"-------
        while continueRoutine:
            # get current time
            t = trialsyundong1Clock.getTime()
            tThisFlip = win.getFutureFlipTime(clock=trialsyundong1Clock)
            tThisFlipGlobal = win.getFutureFlipTime(clock=None)
            frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
            # update/draw components on each frame
            
            # *fixation* updates
            if fixation.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
                # keep track of start time/frame for later
                fixation.frameNStart = frameN  # exact frame index
                fixation.tStart = t  # local t and not account for scr refresh
                fixation.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(fixation, 'tStartRefresh')  # time at next scr refresh
                fixation.setAutoDraw(True)
            if fixation.status == STARTED:
                # is it time to stop? (based on global clock, using actual start)
                if tThisFlipGlobal > fixation.tStartRefresh + 0.5-frameTolerance:
                    # keep track of stop time/frame for later
                    fixation.tStop = t  # not accounting for scr refresh
                    fixation.frameNStop = frameN  # exact frame index
                    win.timeOnFlip(fixation, 'tStopRefresh')  # time at next scr refresh
                    fixation.setAutoDraw(False)
            
            # *text_3* updates
            if text_3.status == NOT_STARTED and tThisFlip >= 0.5-frameTolerance:
                # keep track of start time/frame for later
                text_3.frameNStart = frameN  # exact frame index
                text_3.tStart = t  # local t and not account for scr refresh
                text_3.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(text_3, 'tStartRefresh')  # time at next scr refresh
                text_3.setAutoDraw(True)
            
            # *key_resp_2* updates
            waitOnFlip = False
            if key_resp_2.status == NOT_STARTED and tThisFlip >= 0.5-frameTolerance:
                # keep track of start time/frame for later
                key_resp_2.frameNStart = frameN  # exact frame index
                key_resp_2.tStart = t  # local t and not account for scr refresh
                key_resp_2.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(key_resp_2, 'tStartRefresh')  # time at next scr refresh
                key_resp_2.status = STARTED
                # keyboard checking is just starting
                waitOnFlip = True
                win.callOnFlip(key_resp_2.clock.reset)  # t=0 on next screen flip
                win.callOnFlip(key_resp_2.clearEvents, eventType='keyboard')  # clear events on next screen flip
            if key_resp_2.status == STARTED and not waitOnFlip:
                theseKeys = key_resp_2.getKeys(keyList=['e', 'i'], waitRelease=False)
                _key_resp_2_allKeys.extend(theseKeys)
                if len(_key_resp_2_allKeys):
                    key_resp_2.keys = _key_resp_2_allKeys[-1].name  # just the last key pressed
                    key_resp_2.rt = _key_resp_2_allKeys[-1].rt
                    # was this correct?
                    if (key_resp_2.keys == str(correct_key1)) or (key_resp_2.keys == correct_key1):
                        key_resp_2.corr = 1
                    else:
                        key_resp_2.corr = 0
                    # a response ends the routine
                    continueRoutine = False
            
            # *sportmale* updates
            if sportmale.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
                # keep track of start time/frame for later
                sportmale.frameNStart = frameN  # exact frame index
                sportmale.tStart = t  # local t and not account for scr refresh
                sportmale.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(sportmale, 'tStartRefresh')  # time at next scr refresh
                sportmale.setAutoDraw(True)
            
            # *sportfemale* updates
            if sportfemale.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
                # keep track of start time/frame for later
                sportfemale.frameNStart = frameN  # exact frame index
                sportfemale.tStart = t  # local t and not account for scr refresh
                sportfemale.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(sportfemale, 'tStartRefresh')  # time at next scr refresh
                sportfemale.setAutoDraw(True)
            
            # check for quit (typically the Esc key)
            if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
                core.quit()
            
            # check if all components have finished
            if not continueRoutine:  # a component has requested a forced-end of Routine
                break
            continueRoutine = False  # will revert to True if at least one component still running
            for thisComponent in trialsyundong1Components:
                if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
                    continueRoutine = True
                    break  # at least one component has not yet finished
            
            # refresh the screen
            if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
                win.flip()
        
        # -------Ending Routine "trialsyundong1"-------
        for thisComponent in trialsyundong1Components:
            if hasattr(thisComponent, "setAutoDraw"):
                thisComponent.setAutoDraw(False)
        repeatLoop1.addData('fixation.started', fixation.tStartRefresh)
        repeatLoop1.addData('fixation.stopped', fixation.tStopRefresh)
        repeatLoop1.addData('text_3.started', text_3.tStartRefresh)
        repeatLoop1.addData('text_3.stopped', text_3.tStopRefresh)
        # check responses
        if key_resp_2.keys in ['', [], None]:  # No response was made
            key_resp_2.keys = None
            # was no response the correct answer?!
            if str(correct_key1).lower() == 'none':
               key_resp_2.corr = 1;  # correct non-response
            else:
               key_resp_2.corr = 0;  # failed to respond (incorrectly)
        # store data for repeatLoop1 (TrialHandler)
        repeatLoop1.addData('key_resp_2.keys',key_resp_2.keys)
        repeatLoop1.addData('key_resp_2.corr', key_resp_2.corr)
        if key_resp_2.keys != None:  # we had a response
            repeatLoop1.addData('key_resp_2.rt', key_resp_2.rt)
        repeatLoop1.addData('key_resp_2.started', key_resp_2.tStartRefresh)
        repeatLoop1.addData('key_resp_2.stopped', key_resp_2.tStopRefresh)
        repeatLoop1.addData('sportmale.started', sportmale.tStartRefresh)
        repeatLoop1.addData('sportmale.stopped', sportmale.tStopRefresh)
        repeatLoop1.addData('sportfemale.started', sportfemale.tStartRefresh)
        repeatLoop1.addData('sportfemale.stopped', sportfemale.tStopRefresh)
        # the Routine "trialsyundong1" was not non-slip safe, so reset the non-slip timer
        routineTimer.reset()
        
        # ------Prepare to start Routine "restart_trial1"-------
        continueRoutine = True
        # update component parameters for each repeat
        if key_resp_2.corr==0:
           repeatLoop1.finished = False
        else:
            repeatLoop1.finished = True
        # keep track of which components have finished
        restart_trial1Components = []
        for thisComponent in restart_trial1Components:
            thisComponent.tStart = None
            thisComponent.tStop = None
            thisComponent.tStartRefresh = None
            thisComponent.tStopRefresh = None
            if hasattr(thisComponent, 'status'):
                thisComponent.status = NOT_STARTED
        # reset timers
        t = 0
        _timeToFirstFrame = win.getFutureFlipTime(clock="now")
        restart_trial1Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
        frameN = -1
        
        # -------Run Routine "restart_trial1"-------
        while continueRoutine:
            # get current time
            t = restart_trial1Clock.getTime()
            tThisFlip = win.getFutureFlipTime(clock=restart_trial1Clock)
            tThisFlipGlobal = win.getFutureFlipTime(clock=None)
            frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
            # update/draw components on each frame
            
            # check for quit (typically the Esc key)
            if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
                core.quit()
            
            # check if all components have finished
            if not continueRoutine:  # a component has requested a forced-end of Routine
                break
            continueRoutine = False  # will revert to True if at least one component still running
            for thisComponent in restart_trial1Components:
                if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
                    continueRoutine = True
                    break  # at least one component has not yet finished
            
            # refresh the screen
            if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
                win.flip()
        
        # -------Ending Routine "restart_trial1"-------
        for thisComponent in restart_trial1Components:
            if hasattr(thisComponent, "setAutoDraw"):
                thisComponent.setAutoDraw(False)
        # the Routine "restart_trial1" was not non-slip safe, so reset the non-slip timer
        routineTimer.reset()
        
        # ------Prepare to start Routine "feedback1"-------
        continueRoutine = True
        routineTimer.add(1.000000)
        # update component parameters for each repeat
        if correct_key1 == key_resp_2.keys  :
            feedback_text = ""
        elif correct_key1 != key_resp_2.keys  :
            feedback_text = "❌"
        text1.setText(feedback_text)
        # keep track of which components have finished
        feedback1Components = [text1]
        for thisComponent in feedback1Components:
            thisComponent.tStart = None
            thisComponent.tStop = None
            thisComponent.tStartRefresh = None
            thisComponent.tStopRefresh = None
            if hasattr(thisComponent, 'status'):
                thisComponent.status = NOT_STARTED
        # reset timers
        t = 0
        _timeToFirstFrame = win.getFutureFlipTime(clock="now")
        feedback1Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
        frameN = -1
        
        # -------Run Routine "feedback1"-------
        while continueRoutine and routineTimer.getTime() > 0:
            # get current time
            t = feedback1Clock.getTime()
            tThisFlip = win.getFutureFlipTime(clock=feedback1Clock)
            tThisFlipGlobal = win.getFutureFlipTime(clock=None)
            frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
            # update/draw components on each frame
            
            # *text1* updates
            if text1.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
                # keep track of start time/frame for later
                text1.frameNStart = frameN  # exact frame index
                text1.tStart = t  # local t and not account for scr refresh
                text1.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(text1, 'tStartRefresh')  # time at next scr refresh
                text1.setAutoDraw(True)
            if text1.status == STARTED:
                # is it time to stop? (based on global clock, using actual start)
                if tThisFlipGlobal > text1.tStartRefresh + 1.0-frameTolerance:
                    # keep track of stop time/frame for later
                    text1.tStop = t  # not accounting for scr refresh
                    text1.frameNStop = frameN  # exact frame index
                    win.timeOnFlip(text1, 'tStopRefresh')  # time at next scr refresh
                    text1.setAutoDraw(False)
            
            # check for quit (typically the Esc key)
            if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
                core.quit()
            
            # check if all components have finished
            if not continueRoutine:  # a component has requested a forced-end of Routine
                break
            continueRoutine = False  # will revert to True if at least one component still running
            for thisComponent in feedback1Components:
                if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
                    continueRoutine = True
                    break  # at least one component has not yet finished
            
            # refresh the screen
            if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
                win.flip()
        
        # -------Ending Routine "feedback1"-------
        for thisComponent in feedback1Components:
            if hasattr(thisComponent, "setAutoDraw"):
                thisComponent.setAutoDraw(False)
        repeatLoop1.addData('text1.started', text1.tStartRefresh)
        repeatLoop1.addData('text1.stopped', text1.tStopRefresh)
        thisExp.nextEntry()
        
    # completed 5.0 repeats of 'repeatLoop1'
    
    thisExp.nextEntry()
    
# completed 2.0 repeats of 'loop1'


# ------Prepare to start Routine "instruction2"-------
continueRoutine = True
# update component parameters for each repeat
key_resp_9.keys = []
key_resp_9.rt = []
_key_resp_9_allKeys = []
# keep track of which components have finished
instruction2Components = [image2, key_resp_9]
for thisComponent in instruction2Components:
    thisComponent.tStart = None
    thisComponent.tStop = None
    thisComponent.tStartRefresh = None
    thisComponent.tStopRefresh = None
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED
# reset timers
t = 0
_timeToFirstFrame = win.getFutureFlipTime(clock="now")
instruction2Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
frameN = -1

# -------Run Routine "instruction2"-------
while continueRoutine:
    # get current time
    t = instruction2Clock.getTime()
    tThisFlip = win.getFutureFlipTime(clock=instruction2Clock)
    tThisFlipGlobal = win.getFutureFlipTime(clock=None)
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    # *image2* updates
    if image2.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        image2.frameNStart = frameN  # exact frame index
        image2.tStart = t  # local t and not account for scr refresh
        image2.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(image2, 'tStartRefresh')  # time at next scr refresh
        image2.setAutoDraw(True)
    
    # *key_resp_9* updates
    waitOnFlip = False
    if key_resp_9.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        key_resp_9.frameNStart = frameN  # exact frame index
        key_resp_9.tStart = t  # local t and not account for scr refresh
        key_resp_9.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(key_resp_9, 'tStartRefresh')  # time at next scr refresh
        key_resp_9.status = STARTED
        # keyboard checking is just starting
        waitOnFlip = True
        win.callOnFlip(key_resp_9.clock.reset)  # t=0 on next screen flip
        win.callOnFlip(key_resp_9.clearEvents, eventType='keyboard')  # clear events on next screen flip
    if key_resp_9.status == STARTED and not waitOnFlip:
        theseKeys = key_resp_9.getKeys(keyList=['space'], waitRelease=False)
        _key_resp_9_allKeys.extend(theseKeys)
        if len(_key_resp_9_allKeys):
            key_resp_9.keys = _key_resp_9_allKeys[-1].name  # just the last key pressed
            key_resp_9.rt = _key_resp_9_allKeys[-1].rt
            # a response ends the routine
            continueRoutine = False
    
    # check for quit (typically the Esc key)
    if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
        core.quit()
    
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in instruction2Components:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # refresh the screen
    if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
        win.flip()

# -------Ending Routine "instruction2"-------
for thisComponent in instruction2Components:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)
thisExp.addData('image2.started', image2.tStartRefresh)
thisExp.addData('image2.stopped', image2.tStopRefresh)
# check responses
if key_resp_9.keys in ['', [], None]:  # No response was made
    key_resp_9.keys = None
thisExp.addData('key_resp_9.keys',key_resp_9.keys)
if key_resp_9.keys != None:  # we had a response
    thisExp.addData('key_resp_9.rt', key_resp_9.rt)
thisExp.addData('key_resp_9.started', key_resp_9.tStartRefresh)
thisExp.addData('key_resp_9.stopped', key_resp_9.tStopRefresh)
thisExp.nextEntry()
# the Routine "instruction2" was not non-slip safe, so reset the non-slip timer
routineTimer.reset()

# set up handler to look after randomisation of conditions etc
loop2 = data.TrialHandler(nReps=2.0, method='random', 
    extraInfo=expInfo, originPath=-1,
    trialList=data.importConditions('IAT_block2.xlsx'),
    seed=None, name='loop2')
thisExp.addLoop(loop2)  # add the loop to the experiment
thisLoop2 = loop2.trialList[0]  # so we can initialise stimuli with some values
# abbreviate parameter names if possible (e.g. rgb = thisLoop2.rgb)
if thisLoop2 != None:
    for paramName in thisLoop2:
        exec('{} = thisLoop2[paramName]'.format(paramName))

for thisLoop2 in loop2:
    currentLoop = loop2
    # abbreviate parameter names if possible (e.g. rgb = thisLoop2.rgb)
    if thisLoop2 != None:
        for paramName in thisLoop2:
            exec('{} = thisLoop2[paramName]'.format(paramName))
    
    # set up handler to look after randomisation of conditions etc
    repeatLoop2 = data.TrialHandler(nReps=5.0, method='random', 
        extraInfo=expInfo, originPath=-1,
        trialList=[None],
        seed=None, name='repeatLoop2')
    thisExp.addLoop(repeatLoop2)  # add the loop to the experiment
    thisRepeatLoop2 = repeatLoop2.trialList[0]  # so we can initialise stimuli with some values
    # abbreviate parameter names if possible (e.g. rgb = thisRepeatLoop2.rgb)
    if thisRepeatLoop2 != None:
        for paramName in thisRepeatLoop2:
            exec('{} = thisRepeatLoop2[paramName]'.format(paramName))
    
    for thisRepeatLoop2 in repeatLoop2:
        currentLoop = repeatLoop2
        # abbreviate parameter names if possible (e.g. rgb = thisRepeatLoop2.rgb)
        if thisRepeatLoop2 != None:
            for paramName in thisRepeatLoop2:
                exec('{} = thisRepeatLoop2[paramName]'.format(paramName))
        
        # ------Prepare to start Routine "trialface1"-------
        continueRoutine = True
        # update component parameters for each repeat
        stims2.setText(stims22)
        key_resp_3.keys = []
        key_resp_3.rt = []
        _key_resp_3_allKeys = []
        # keep track of which components have finished
        trialface1Components = [fixation_2, stims2, key_resp_3, malename, femalename]
        for thisComponent in trialface1Components:
            thisComponent.tStart = None
            thisComponent.tStop = None
            thisComponent.tStartRefresh = None
            thisComponent.tStopRefresh = None
            if hasattr(thisComponent, 'status'):
                thisComponent.status = NOT_STARTED
        # reset timers
        t = 0
        _timeToFirstFrame = win.getFutureFlipTime(clock="now")
        trialface1Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
        frameN = -1
        
        # -------Run Routine "trialface1"-------
        while continueRoutine:
            # get current time
            t = trialface1Clock.getTime()
            tThisFlip = win.getFutureFlipTime(clock=trialface1Clock)
            tThisFlipGlobal = win.getFutureFlipTime(clock=None)
            frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
            # update/draw components on each frame
            
            # *fixation_2* updates
            if fixation_2.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
                # keep track of start time/frame for later
                fixation_2.frameNStart = frameN  # exact frame index
                fixation_2.tStart = t  # local t and not account for scr refresh
                fixation_2.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(fixation_2, 'tStartRefresh')  # time at next scr refresh
                fixation_2.setAutoDraw(True)
            if fixation_2.status == STARTED:
                # is it time to stop? (based on global clock, using actual start)
                if tThisFlipGlobal > fixation_2.tStartRefresh + 0.5-frameTolerance:
                    # keep track of stop time/frame for later
                    fixation_2.tStop = t  # not accounting for scr refresh
                    fixation_2.frameNStop = frameN  # exact frame index
                    win.timeOnFlip(fixation_2, 'tStopRefresh')  # time at next scr refresh
                    fixation_2.setAutoDraw(False)
            
            # *stims2* updates
            if stims2.status == NOT_STARTED and tThisFlip >= 0.5-frameTolerance:
                # keep track of start time/frame for later
                stims2.frameNStart = frameN  # exact frame index
                stims2.tStart = t  # local t and not account for scr refresh
                stims2.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(stims2, 'tStartRefresh')  # time at next scr refresh
                stims2.setAutoDraw(True)
            
            # *key_resp_3* updates
            waitOnFlip = False
            if key_resp_3.status == NOT_STARTED and tThisFlip >= 0.5-frameTolerance:
                # keep track of start time/frame for later
                key_resp_3.frameNStart = frameN  # exact frame index
                key_resp_3.tStart = t  # local t and not account for scr refresh
                key_resp_3.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(key_resp_3, 'tStartRefresh')  # time at next scr refresh
                key_resp_3.status = STARTED
                # keyboard checking is just starting
                waitOnFlip = True
                win.callOnFlip(key_resp_3.clock.reset)  # t=0 on next screen flip
                win.callOnFlip(key_resp_3.clearEvents, eventType='keyboard')  # clear events on next screen flip
            if key_resp_3.status == STARTED and not waitOnFlip:
                theseKeys = key_resp_3.getKeys(keyList=['e', 'i'], waitRelease=False)
                _key_resp_3_allKeys.extend(theseKeys)
                if len(_key_resp_3_allKeys):
                    key_resp_3.keys = _key_resp_3_allKeys[-1].name  # just the last key pressed
                    key_resp_3.rt = _key_resp_3_allKeys[-1].rt
                    # was this correct?
                    if (key_resp_3.keys == str(correct_key2)) or (key_resp_3.keys == correct_key2):
                        key_resp_3.corr = 1
                    else:
                        key_resp_3.corr = 0
                    # a response ends the routine
                    continueRoutine = False
            
            # *malename* updates
            if malename.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
                # keep track of start time/frame for later
                malename.frameNStart = frameN  # exact frame index
                malename.tStart = t  # local t and not account for scr refresh
                malename.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(malename, 'tStartRefresh')  # time at next scr refresh
                malename.setAutoDraw(True)
            
            # *femalename* updates
            if femalename.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
                # keep track of start time/frame for later
                femalename.frameNStart = frameN  # exact frame index
                femalename.tStart = t  # local t and not account for scr refresh
                femalename.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(femalename, 'tStartRefresh')  # time at next scr refresh
                femalename.setAutoDraw(True)
            
            # check for quit (typically the Esc key)
            if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
                core.quit()
            
            # check if all components have finished
            if not continueRoutine:  # a component has requested a forced-end of Routine
                break
            continueRoutine = False  # will revert to True if at least one component still running
            for thisComponent in trialface1Components:
                if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
                    continueRoutine = True
                    break  # at least one component has not yet finished
            
            # refresh the screen
            if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
                win.flip()
        
        # -------Ending Routine "trialface1"-------
        for thisComponent in trialface1Components:
            if hasattr(thisComponent, "setAutoDraw"):
                thisComponent.setAutoDraw(False)
        repeatLoop2.addData('fixation_2.started', fixation_2.tStartRefresh)
        repeatLoop2.addData('fixation_2.stopped', fixation_2.tStopRefresh)
        repeatLoop2.addData('stims2.started', stims2.tStartRefresh)
        repeatLoop2.addData('stims2.stopped', stims2.tStopRefresh)
        # check responses
        if key_resp_3.keys in ['', [], None]:  # No response was made
            key_resp_3.keys = None
            # was no response the correct answer?!
            if str(correct_key2).lower() == 'none':
               key_resp_3.corr = 1;  # correct non-response
            else:
               key_resp_3.corr = 0;  # failed to respond (incorrectly)
        # store data for repeatLoop2 (TrialHandler)
        repeatLoop2.addData('key_resp_3.keys',key_resp_3.keys)
        repeatLoop2.addData('key_resp_3.corr', key_resp_3.corr)
        if key_resp_3.keys != None:  # we had a response
            repeatLoop2.addData('key_resp_3.rt', key_resp_3.rt)
        repeatLoop2.addData('key_resp_3.started', key_resp_3.tStartRefresh)
        repeatLoop2.addData('key_resp_3.stopped', key_resp_3.tStopRefresh)
        repeatLoop2.addData('malename.started', malename.tStartRefresh)
        repeatLoop2.addData('malename.stopped', malename.tStopRefresh)
        repeatLoop2.addData('femalename.started', femalename.tStartRefresh)
        repeatLoop2.addData('femalename.stopped', femalename.tStopRefresh)
        # the Routine "trialface1" was not non-slip safe, so reset the non-slip timer
        routineTimer.reset()
        
        # ------Prepare to start Routine "restart_trial2"-------
        continueRoutine = True
        # update component parameters for each repeat
        if key_resp_3.corr==0:
           repeatLoop2.finished = False
        else:
            repeatLoop2.finished = True
        # keep track of which components have finished
        restart_trial2Components = []
        for thisComponent in restart_trial2Components:
            thisComponent.tStart = None
            thisComponent.tStop = None
            thisComponent.tStartRefresh = None
            thisComponent.tStopRefresh = None
            if hasattr(thisComponent, 'status'):
                thisComponent.status = NOT_STARTED
        # reset timers
        t = 0
        _timeToFirstFrame = win.getFutureFlipTime(clock="now")
        restart_trial2Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
        frameN = -1
        
        # -------Run Routine "restart_trial2"-------
        while continueRoutine:
            # get current time
            t = restart_trial2Clock.getTime()
            tThisFlip = win.getFutureFlipTime(clock=restart_trial2Clock)
            tThisFlipGlobal = win.getFutureFlipTime(clock=None)
            frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
            # update/draw components on each frame
            
            # check for quit (typically the Esc key)
            if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
                core.quit()
            
            # check if all components have finished
            if not continueRoutine:  # a component has requested a forced-end of Routine
                break
            continueRoutine = False  # will revert to True if at least one component still running
            for thisComponent in restart_trial2Components:
                if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
                    continueRoutine = True
                    break  # at least one component has not yet finished
            
            # refresh the screen
            if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
                win.flip()
        
        # -------Ending Routine "restart_trial2"-------
        for thisComponent in restart_trial2Components:
            if hasattr(thisComponent, "setAutoDraw"):
                thisComponent.setAutoDraw(False)
        # the Routine "restart_trial2" was not non-slip safe, so reset the non-slip timer
        routineTimer.reset()
        
        # ------Prepare to start Routine "feedback2"-------
        continueRoutine = True
        routineTimer.add(1.000000)
        # update component parameters for each repeat
        if correct_key2 == key_resp_3.keys  :
            feedback_text = ""
        elif correct_key2 != key_resp_3.keys  :
            feedback_text = "❌"
        text2.setText(feedback_text)
        # keep track of which components have finished
        feedback2Components = [text2]
        for thisComponent in feedback2Components:
            thisComponent.tStart = None
            thisComponent.tStop = None
            thisComponent.tStartRefresh = None
            thisComponent.tStopRefresh = None
            if hasattr(thisComponent, 'status'):
                thisComponent.status = NOT_STARTED
        # reset timers
        t = 0
        _timeToFirstFrame = win.getFutureFlipTime(clock="now")
        feedback2Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
        frameN = -1
        
        # -------Run Routine "feedback2"-------
        while continueRoutine and routineTimer.getTime() > 0:
            # get current time
            t = feedback2Clock.getTime()
            tThisFlip = win.getFutureFlipTime(clock=feedback2Clock)
            tThisFlipGlobal = win.getFutureFlipTime(clock=None)
            frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
            # update/draw components on each frame
            
            # *text2* updates
            if text2.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
                # keep track of start time/frame for later
                text2.frameNStart = frameN  # exact frame index
                text2.tStart = t  # local t and not account for scr refresh
                text2.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(text2, 'tStartRefresh')  # time at next scr refresh
                text2.setAutoDraw(True)
            if text2.status == STARTED:
                # is it time to stop? (based on global clock, using actual start)
                if tThisFlipGlobal > text2.tStartRefresh + 1.0-frameTolerance:
                    # keep track of stop time/frame for later
                    text2.tStop = t  # not accounting for scr refresh
                    text2.frameNStop = frameN  # exact frame index
                    win.timeOnFlip(text2, 'tStopRefresh')  # time at next scr refresh
                    text2.setAutoDraw(False)
            
            # check for quit (typically the Esc key)
            if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
                core.quit()
            
            # check if all components have finished
            if not continueRoutine:  # a component has requested a forced-end of Routine
                break
            continueRoutine = False  # will revert to True if at least one component still running
            for thisComponent in feedback2Components:
                if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
                    continueRoutine = True
                    break  # at least one component has not yet finished
            
            # refresh the screen
            if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
                win.flip()
        
        # -------Ending Routine "feedback2"-------
        for thisComponent in feedback2Components:
            if hasattr(thisComponent, "setAutoDraw"):
                thisComponent.setAutoDraw(False)
        repeatLoop2.addData('text2.started', text2.tStartRefresh)
        repeatLoop2.addData('text2.stopped', text2.tStopRefresh)
        thisExp.nextEntry()
        
    # completed 5.0 repeats of 'repeatLoop2'
    
    thisExp.nextEntry()
    
# completed 2.0 repeats of 'loop2'


# ------Prepare to start Routine "instruction3"-------
continueRoutine = True
# update component parameters for each repeat
key_resp_10.keys = []
key_resp_10.rt = []
_key_resp_10_allKeys = []
# keep track of which components have finished
instruction3Components = [image3, key_resp_10]
for thisComponent in instruction3Components:
    thisComponent.tStart = None
    thisComponent.tStop = None
    thisComponent.tStartRefresh = None
    thisComponent.tStopRefresh = None
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED
# reset timers
t = 0
_timeToFirstFrame = win.getFutureFlipTime(clock="now")
instruction3Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
frameN = -1

# -------Run Routine "instruction3"-------
while continueRoutine:
    # get current time
    t = instruction3Clock.getTime()
    tThisFlip = win.getFutureFlipTime(clock=instruction3Clock)
    tThisFlipGlobal = win.getFutureFlipTime(clock=None)
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    # *image3* updates
    if image3.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        image3.frameNStart = frameN  # exact frame index
        image3.tStart = t  # local t and not account for scr refresh
        image3.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(image3, 'tStartRefresh')  # time at next scr refresh
        image3.setAutoDraw(True)
    
    # *key_resp_10* updates
    waitOnFlip = False
    if key_resp_10.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        key_resp_10.frameNStart = frameN  # exact frame index
        key_resp_10.tStart = t  # local t and not account for scr refresh
        key_resp_10.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(key_resp_10, 'tStartRefresh')  # time at next scr refresh
        key_resp_10.status = STARTED
        # keyboard checking is just starting
        waitOnFlip = True
        win.callOnFlip(key_resp_10.clock.reset)  # t=0 on next screen flip
        win.callOnFlip(key_resp_10.clearEvents, eventType='keyboard')  # clear events on next screen flip
    if key_resp_10.status == STARTED and not waitOnFlip:
        theseKeys = key_resp_10.getKeys(keyList=['space'], waitRelease=False)
        _key_resp_10_allKeys.extend(theseKeys)
        if len(_key_resp_10_allKeys):
            key_resp_10.keys = _key_resp_10_allKeys[-1].name  # just the last key pressed
            key_resp_10.rt = _key_resp_10_allKeys[-1].rt
            # a response ends the routine
            continueRoutine = False
    
    # check for quit (typically the Esc key)
    if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
        core.quit()
    
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in instruction3Components:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # refresh the screen
    if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
        win.flip()

# -------Ending Routine "instruction3"-------
for thisComponent in instruction3Components:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)
thisExp.addData('image3.started', image3.tStartRefresh)
thisExp.addData('image3.stopped', image3.tStopRefresh)
# check responses
if key_resp_10.keys in ['', [], None]:  # No response was made
    key_resp_10.keys = None
thisExp.addData('key_resp_10.keys',key_resp_10.keys)
if key_resp_10.keys != None:  # we had a response
    thisExp.addData('key_resp_10.rt', key_resp_10.rt)
thisExp.addData('key_resp_10.started', key_resp_10.tStartRefresh)
thisExp.addData('key_resp_10.stopped', key_resp_10.tStopRefresh)
thisExp.nextEntry()
# the Routine "instruction3" was not non-slip safe, so reset the non-slip timer
routineTimer.reset()

# set up handler to look after randomisation of conditions etc
loop3 = data.TrialHandler(nReps=2.0, method='random', 
    extraInfo=expInfo, originPath=-1,
    trialList=data.importConditions('IAT_block3.xlsx'),
    seed=None, name='loop3')
thisExp.addLoop(loop3)  # add the loop to the experiment
thisLoop3 = loop3.trialList[0]  # so we can initialise stimuli with some values
# abbreviate parameter names if possible (e.g. rgb = thisLoop3.rgb)
if thisLoop3 != None:
    for paramName in thisLoop3:
        exec('{} = thisLoop3[paramName]'.format(paramName))

for thisLoop3 in loop3:
    currentLoop = loop3
    # abbreviate parameter names if possible (e.g. rgb = thisLoop3.rgb)
    if thisLoop3 != None:
        for paramName in thisLoop3:
            exec('{} = thisLoop3[paramName]'.format(paramName))
    
    # set up handler to look after randomisation of conditions etc
    repeatLoop3 = data.TrialHandler(nReps=5.0, method='random', 
        extraInfo=expInfo, originPath=-1,
        trialList=[None],
        seed=None, name='repeatLoop3')
    thisExp.addLoop(repeatLoop3)  # add the loop to the experiment
    thisRepeatLoop3 = repeatLoop3.trialList[0]  # so we can initialise stimuli with some values
    # abbreviate parameter names if possible (e.g. rgb = thisRepeatLoop3.rgb)
    if thisRepeatLoop3 != None:
        for paramName in thisRepeatLoop3:
            exec('{} = thisRepeatLoop3[paramName]'.format(paramName))
    
    for thisRepeatLoop3 in repeatLoop3:
        currentLoop = repeatLoop3
        # abbreviate parameter names if possible (e.g. rgb = thisRepeatLoop3.rgb)
        if thisRepeatLoop3 != None:
            for paramName in thisRepeatLoop3:
                exec('{} = thisRepeatLoop3[paramName]'.format(paramName))
        
        # ------Prepare to start Routine "trialsprac1"-------
        continueRoutine = True
        # update component parameters for each repeat
        stims3.setText(stims33)
        key_resp_4.keys = []
        key_resp_4.rt = []
        _key_resp_4_allKeys = []
        # keep track of which components have finished
        trialsprac1Components = [fixation3, stims3, key_resp_4, mm1, FF1]
        for thisComponent in trialsprac1Components:
            thisComponent.tStart = None
            thisComponent.tStop = None
            thisComponent.tStartRefresh = None
            thisComponent.tStopRefresh = None
            if hasattr(thisComponent, 'status'):
                thisComponent.status = NOT_STARTED
        # reset timers
        t = 0
        _timeToFirstFrame = win.getFutureFlipTime(clock="now")
        trialsprac1Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
        frameN = -1
        
        # -------Run Routine "trialsprac1"-------
        while continueRoutine:
            # get current time
            t = trialsprac1Clock.getTime()
            tThisFlip = win.getFutureFlipTime(clock=trialsprac1Clock)
            tThisFlipGlobal = win.getFutureFlipTime(clock=None)
            frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
            # update/draw components on each frame
            
            # *fixation3* updates
            if fixation3.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
                # keep track of start time/frame for later
                fixation3.frameNStart = frameN  # exact frame index
                fixation3.tStart = t  # local t and not account for scr refresh
                fixation3.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(fixation3, 'tStartRefresh')  # time at next scr refresh
                fixation3.setAutoDraw(True)
            if fixation3.status == STARTED:
                # is it time to stop? (based on global clock, using actual start)
                if tThisFlipGlobal > fixation3.tStartRefresh + 0.5-frameTolerance:
                    # keep track of stop time/frame for later
                    fixation3.tStop = t  # not accounting for scr refresh
                    fixation3.frameNStop = frameN  # exact frame index
                    win.timeOnFlip(fixation3, 'tStopRefresh')  # time at next scr refresh
                    fixation3.setAutoDraw(False)
            
            # *stims3* updates
            if stims3.status == NOT_STARTED and tThisFlip >= 0.5-frameTolerance:
                # keep track of start time/frame for later
                stims3.frameNStart = frameN  # exact frame index
                stims3.tStart = t  # local t and not account for scr refresh
                stims3.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(stims3, 'tStartRefresh')  # time at next scr refresh
                stims3.setAutoDraw(True)
            
            # *key_resp_4* updates
            waitOnFlip = False
            if key_resp_4.status == NOT_STARTED and tThisFlip >= 0.5-frameTolerance:
                # keep track of start time/frame for later
                key_resp_4.frameNStart = frameN  # exact frame index
                key_resp_4.tStart = t  # local t and not account for scr refresh
                key_resp_4.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(key_resp_4, 'tStartRefresh')  # time at next scr refresh
                key_resp_4.status = STARTED
                # keyboard checking is just starting
                waitOnFlip = True
                win.callOnFlip(key_resp_4.clock.reset)  # t=0 on next screen flip
                win.callOnFlip(key_resp_4.clearEvents, eventType='keyboard')  # clear events on next screen flip
            if key_resp_4.status == STARTED and not waitOnFlip:
                theseKeys = key_resp_4.getKeys(keyList=['e', 'i'], waitRelease=False)
                _key_resp_4_allKeys.extend(theseKeys)
                if len(_key_resp_4_allKeys):
                    key_resp_4.keys = _key_resp_4_allKeys[-1].name  # just the last key pressed
                    key_resp_4.rt = _key_resp_4_allKeys[-1].rt
                    # was this correct?
                    if (key_resp_4.keys == str(correct_key3)) or (key_resp_4.keys == correct_key3):
                        key_resp_4.corr = 1
                    else:
                        key_resp_4.corr = 0
                    # a response ends the routine
                    continueRoutine = False
            
            # *mm1* updates
            if mm1.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
                # keep track of start time/frame for later
                mm1.frameNStart = frameN  # exact frame index
                mm1.tStart = t  # local t and not account for scr refresh
                mm1.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(mm1, 'tStartRefresh')  # time at next scr refresh
                mm1.setAutoDraw(True)
            
            # *FF1* updates
            if FF1.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
                # keep track of start time/frame for later
                FF1.frameNStart = frameN  # exact frame index
                FF1.tStart = t  # local t and not account for scr refresh
                FF1.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(FF1, 'tStartRefresh')  # time at next scr refresh
                FF1.setAutoDraw(True)
            
            # check for quit (typically the Esc key)
            if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
                core.quit()
            
            # check if all components have finished
            if not continueRoutine:  # a component has requested a forced-end of Routine
                break
            continueRoutine = False  # will revert to True if at least one component still running
            for thisComponent in trialsprac1Components:
                if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
                    continueRoutine = True
                    break  # at least one component has not yet finished
            
            # refresh the screen
            if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
                win.flip()
        
        # -------Ending Routine "trialsprac1"-------
        for thisComponent in trialsprac1Components:
            if hasattr(thisComponent, "setAutoDraw"):
                thisComponent.setAutoDraw(False)
        repeatLoop3.addData('fixation3.started', fixation3.tStartRefresh)
        repeatLoop3.addData('fixation3.stopped', fixation3.tStopRefresh)
        repeatLoop3.addData('stims3.started', stims3.tStartRefresh)
        repeatLoop3.addData('stims3.stopped', stims3.tStopRefresh)
        # check responses
        if key_resp_4.keys in ['', [], None]:  # No response was made
            key_resp_4.keys = None
            # was no response the correct answer?!
            if str(correct_key3).lower() == 'none':
               key_resp_4.corr = 1;  # correct non-response
            else:
               key_resp_4.corr = 0;  # failed to respond (incorrectly)
        # store data for repeatLoop3 (TrialHandler)
        repeatLoop3.addData('key_resp_4.keys',key_resp_4.keys)
        repeatLoop3.addData('key_resp_4.corr', key_resp_4.corr)
        if key_resp_4.keys != None:  # we had a response
            repeatLoop3.addData('key_resp_4.rt', key_resp_4.rt)
        repeatLoop3.addData('key_resp_4.started', key_resp_4.tStartRefresh)
        repeatLoop3.addData('key_resp_4.stopped', key_resp_4.tStopRefresh)
        repeatLoop3.addData('mm1.started', mm1.tStartRefresh)
        repeatLoop3.addData('mm1.stopped', mm1.tStopRefresh)
        repeatLoop3.addData('FF1.started', FF1.tStartRefresh)
        repeatLoop3.addData('FF1.stopped', FF1.tStopRefresh)
        # the Routine "trialsprac1" was not non-slip safe, so reset the non-slip timer
        routineTimer.reset()
        
        # ------Prepare to start Routine "restart_trial3"-------
        continueRoutine = True
        # update component parameters for each repeat
        if  key_resp_4.corr==0:
           repeatLoop3.finished = False
        else:
            repeatLoop3.finished = True
        # keep track of which components have finished
        restart_trial3Components = []
        for thisComponent in restart_trial3Components:
            thisComponent.tStart = None
            thisComponent.tStop = None
            thisComponent.tStartRefresh = None
            thisComponent.tStopRefresh = None
            if hasattr(thisComponent, 'status'):
                thisComponent.status = NOT_STARTED
        # reset timers
        t = 0
        _timeToFirstFrame = win.getFutureFlipTime(clock="now")
        restart_trial3Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
        frameN = -1
        
        # -------Run Routine "restart_trial3"-------
        while continueRoutine:
            # get current time
            t = restart_trial3Clock.getTime()
            tThisFlip = win.getFutureFlipTime(clock=restart_trial3Clock)
            tThisFlipGlobal = win.getFutureFlipTime(clock=None)
            frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
            # update/draw components on each frame
            
            # check for quit (typically the Esc key)
            if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
                core.quit()
            
            # check if all components have finished
            if not continueRoutine:  # a component has requested a forced-end of Routine
                break
            continueRoutine = False  # will revert to True if at least one component still running
            for thisComponent in restart_trial3Components:
                if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
                    continueRoutine = True
                    break  # at least one component has not yet finished
            
            # refresh the screen
            if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
                win.flip()
        
        # -------Ending Routine "restart_trial3"-------
        for thisComponent in restart_trial3Components:
            if hasattr(thisComponent, "setAutoDraw"):
                thisComponent.setAutoDraw(False)
        # the Routine "restart_trial3" was not non-slip safe, so reset the non-slip timer
        routineTimer.reset()
        
        # ------Prepare to start Routine "feedback3"-------
        continueRoutine = True
        routineTimer.add(1.000000)
        # update component parameters for each repeat
        if correct_key3 == key_resp_4.keys  :
            feedback_text = ""
        elif correct_key3 != key_resp_4.keys  :
            feedback_text = "❌"
        text2_2.setText(feedback_text)
        # keep track of which components have finished
        feedback3Components = [text2_2]
        for thisComponent in feedback3Components:
            thisComponent.tStart = None
            thisComponent.tStop = None
            thisComponent.tStartRefresh = None
            thisComponent.tStopRefresh = None
            if hasattr(thisComponent, 'status'):
                thisComponent.status = NOT_STARTED
        # reset timers
        t = 0
        _timeToFirstFrame = win.getFutureFlipTime(clock="now")
        feedback3Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
        frameN = -1
        
        # -------Run Routine "feedback3"-------
        while continueRoutine and routineTimer.getTime() > 0:
            # get current time
            t = feedback3Clock.getTime()
            tThisFlip = win.getFutureFlipTime(clock=feedback3Clock)
            tThisFlipGlobal = win.getFutureFlipTime(clock=None)
            frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
            # update/draw components on each frame
            
            # *text2_2* updates
            if text2_2.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
                # keep track of start time/frame for later
                text2_2.frameNStart = frameN  # exact frame index
                text2_2.tStart = t  # local t and not account for scr refresh
                text2_2.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(text2_2, 'tStartRefresh')  # time at next scr refresh
                text2_2.setAutoDraw(True)
            if text2_2.status == STARTED:
                # is it time to stop? (based on global clock, using actual start)
                if tThisFlipGlobal > text2_2.tStartRefresh + 1.0-frameTolerance:
                    # keep track of stop time/frame for later
                    text2_2.tStop = t  # not accounting for scr refresh
                    text2_2.frameNStop = frameN  # exact frame index
                    win.timeOnFlip(text2_2, 'tStopRefresh')  # time at next scr refresh
                    text2_2.setAutoDraw(False)
            
            # check for quit (typically the Esc key)
            if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
                core.quit()
            
            # check if all components have finished
            if not continueRoutine:  # a component has requested a forced-end of Routine
                break
            continueRoutine = False  # will revert to True if at least one component still running
            for thisComponent in feedback3Components:
                if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
                    continueRoutine = True
                    break  # at least one component has not yet finished
            
            # refresh the screen
            if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
                win.flip()
        
        # -------Ending Routine "feedback3"-------
        for thisComponent in feedback3Components:
            if hasattr(thisComponent, "setAutoDraw"):
                thisComponent.setAutoDraw(False)
        repeatLoop3.addData('text2_2.started', text2_2.tStartRefresh)
        repeatLoop3.addData('text2_2.stopped', text2_2.tStopRefresh)
        thisExp.nextEntry()
        
    # completed 5.0 repeats of 'repeatLoop3'
    
    thisExp.nextEntry()
    
# completed 2.0 repeats of 'loop3'


# ------Prepare to start Routine "instruction4"-------
continueRoutine = True
# update component parameters for each repeat
key_resp_11.keys = []
key_resp_11.rt = []
_key_resp_11_allKeys = []
# keep track of which components have finished
instruction4Components = [image4, key_resp_11]
for thisComponent in instruction4Components:
    thisComponent.tStart = None
    thisComponent.tStop = None
    thisComponent.tStartRefresh = None
    thisComponent.tStopRefresh = None
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED
# reset timers
t = 0
_timeToFirstFrame = win.getFutureFlipTime(clock="now")
instruction4Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
frameN = -1

# -------Run Routine "instruction4"-------
while continueRoutine:
    # get current time
    t = instruction4Clock.getTime()
    tThisFlip = win.getFutureFlipTime(clock=instruction4Clock)
    tThisFlipGlobal = win.getFutureFlipTime(clock=None)
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    # *image4* updates
    if image4.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        image4.frameNStart = frameN  # exact frame index
        image4.tStart = t  # local t and not account for scr refresh
        image4.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(image4, 'tStartRefresh')  # time at next scr refresh
        image4.setAutoDraw(True)
    
    # *key_resp_11* updates
    waitOnFlip = False
    if key_resp_11.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        key_resp_11.frameNStart = frameN  # exact frame index
        key_resp_11.tStart = t  # local t and not account for scr refresh
        key_resp_11.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(key_resp_11, 'tStartRefresh')  # time at next scr refresh
        key_resp_11.status = STARTED
        # keyboard checking is just starting
        waitOnFlip = True
        win.callOnFlip(key_resp_11.clock.reset)  # t=0 on next screen flip
        win.callOnFlip(key_resp_11.clearEvents, eventType='keyboard')  # clear events on next screen flip
    if key_resp_11.status == STARTED and not waitOnFlip:
        theseKeys = key_resp_11.getKeys(keyList=['space'], waitRelease=False)
        _key_resp_11_allKeys.extend(theseKeys)
        if len(_key_resp_11_allKeys):
            key_resp_11.keys = _key_resp_11_allKeys[-1].name  # just the last key pressed
            key_resp_11.rt = _key_resp_11_allKeys[-1].rt
            # a response ends the routine
            continueRoutine = False
    
    # check for quit (typically the Esc key)
    if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
        core.quit()
    
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in instruction4Components:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # refresh the screen
    if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
        win.flip()

# -------Ending Routine "instruction4"-------
for thisComponent in instruction4Components:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)
thisExp.addData('image4.started', image4.tStartRefresh)
thisExp.addData('image4.stopped', image4.tStopRefresh)
# check responses
if key_resp_11.keys in ['', [], None]:  # No response was made
    key_resp_11.keys = None
thisExp.addData('key_resp_11.keys',key_resp_11.keys)
if key_resp_11.keys != None:  # we had a response
    thisExp.addData('key_resp_11.rt', key_resp_11.rt)
thisExp.addData('key_resp_11.started', key_resp_11.tStartRefresh)
thisExp.addData('key_resp_11.stopped', key_resp_11.tStopRefresh)
thisExp.nextEntry()
# the Routine "instruction4" was not non-slip safe, so reset the non-slip timer
routineTimer.reset()

# set up handler to look after randomisation of conditions etc
loop4 = data.TrialHandler(nReps=2.0, method='random', 
    extraInfo=expInfo, originPath=-1,
    trialList=data.importConditions('IAT_block4.xlsx'),
    seed=None, name='loop4')
thisExp.addLoop(loop4)  # add the loop to the experiment
thisLoop4 = loop4.trialList[0]  # so we can initialise stimuli with some values
# abbreviate parameter names if possible (e.g. rgb = thisLoop4.rgb)
if thisLoop4 != None:
    for paramName in thisLoop4:
        exec('{} = thisLoop4[paramName]'.format(paramName))

for thisLoop4 in loop4:
    currentLoop = loop4
    # abbreviate parameter names if possible (e.g. rgb = thisLoop4.rgb)
    if thisLoop4 != None:
        for paramName in thisLoop4:
            exec('{} = thisLoop4[paramName]'.format(paramName))
    
    # ------Prepare to start Routine "trialszs1"-------
    continueRoutine = True
    # update component parameters for each repeat
    stims4.setText(stims44)
    key_resp_5.keys = []
    key_resp_5.rt = []
    _key_resp_5_allKeys = []
    # keep track of which components have finished
    trialszs1Components = [fixation4, stims4, key_resp_5, mm1_2, FF1_2]
    for thisComponent in trialszs1Components:
        thisComponent.tStart = None
        thisComponent.tStop = None
        thisComponent.tStartRefresh = None
        thisComponent.tStopRefresh = None
        if hasattr(thisComponent, 'status'):
            thisComponent.status = NOT_STARTED
    # reset timers
    t = 0
    _timeToFirstFrame = win.getFutureFlipTime(clock="now")
    trialszs1Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
    frameN = -1
    
    # -------Run Routine "trialszs1"-------
    while continueRoutine:
        # get current time
        t = trialszs1Clock.getTime()
        tThisFlip = win.getFutureFlipTime(clock=trialszs1Clock)
        tThisFlipGlobal = win.getFutureFlipTime(clock=None)
        frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
        # update/draw components on each frame
        
        # *fixation4* updates
        if fixation4.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
            # keep track of start time/frame for later
            fixation4.frameNStart = frameN  # exact frame index
            fixation4.tStart = t  # local t and not account for scr refresh
            fixation4.tStartRefresh = tThisFlipGlobal  # on global time
            win.timeOnFlip(fixation4, 'tStartRefresh')  # time at next scr refresh
            fixation4.setAutoDraw(True)
        if fixation4.status == STARTED:
            # is it time to stop? (based on global clock, using actual start)
            if tThisFlipGlobal > fixation4.tStartRefresh + 0.5-frameTolerance:
                # keep track of stop time/frame for later
                fixation4.tStop = t  # not accounting for scr refresh
                fixation4.frameNStop = frameN  # exact frame index
                win.timeOnFlip(fixation4, 'tStopRefresh')  # time at next scr refresh
                fixation4.setAutoDraw(False)
        
        # *stims4* updates
        if stims4.status == NOT_STARTED and tThisFlip >= 0.5-frameTolerance:
            # keep track of start time/frame for later
            stims4.frameNStart = frameN  # exact frame index
            stims4.tStart = t  # local t and not account for scr refresh
            stims4.tStartRefresh = tThisFlipGlobal  # on global time
            win.timeOnFlip(stims4, 'tStartRefresh')  # time at next scr refresh
            stims4.setAutoDraw(True)
        
        # *key_resp_5* updates
        waitOnFlip = False
        if key_resp_5.status == NOT_STARTED and tThisFlip >= 0.5-frameTolerance:
            # keep track of start time/frame for later
            key_resp_5.frameNStart = frameN  # exact frame index
            key_resp_5.tStart = t  # local t and not account for scr refresh
            key_resp_5.tStartRefresh = tThisFlipGlobal  # on global time
            win.timeOnFlip(key_resp_5, 'tStartRefresh')  # time at next scr refresh
            key_resp_5.status = STARTED
            # keyboard checking is just starting
            waitOnFlip = True
            win.callOnFlip(key_resp_5.clock.reset)  # t=0 on next screen flip
            win.callOnFlip(key_resp_5.clearEvents, eventType='keyboard')  # clear events on next screen flip
        if key_resp_5.status == STARTED and not waitOnFlip:
            theseKeys = key_resp_5.getKeys(keyList=['e', 'i'], waitRelease=False)
            _key_resp_5_allKeys.extend(theseKeys)
            if len(_key_resp_5_allKeys):
                key_resp_5.keys = _key_resp_5_allKeys[-1].name  # just the last key pressed
                key_resp_5.rt = _key_resp_5_allKeys[-1].rt
                # was this correct?
                if (key_resp_5.keys == str(correct_key4)) or (key_resp_5.keys == correct_key4):
                    key_resp_5.corr = 1
                else:
                    key_resp_5.corr = 0
                # a response ends the routine
                continueRoutine = False
        
        # *mm1_2* updates
        if mm1_2.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
            # keep track of start time/frame for later
            mm1_2.frameNStart = frameN  # exact frame index
            mm1_2.tStart = t  # local t and not account for scr refresh
            mm1_2.tStartRefresh = tThisFlipGlobal  # on global time
            win.timeOnFlip(mm1_2, 'tStartRefresh')  # time at next scr refresh
            mm1_2.setAutoDraw(True)
        
        # *FF1_2* updates
        if FF1_2.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
            # keep track of start time/frame for later
            FF1_2.frameNStart = frameN  # exact frame index
            FF1_2.tStart = t  # local t and not account for scr refresh
            FF1_2.tStartRefresh = tThisFlipGlobal  # on global time
            win.timeOnFlip(FF1_2, 'tStartRefresh')  # time at next scr refresh
            FF1_2.setAutoDraw(True)
        
        # check for quit (typically the Esc key)
        if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
            core.quit()
        
        # check if all components have finished
        if not continueRoutine:  # a component has requested a forced-end of Routine
            break
        continueRoutine = False  # will revert to True if at least one component still running
        for thisComponent in trialszs1Components:
            if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
                continueRoutine = True
                break  # at least one component has not yet finished
        
        # refresh the screen
        if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
            win.flip()
    
    # -------Ending Routine "trialszs1"-------
    for thisComponent in trialszs1Components:
        if hasattr(thisComponent, "setAutoDraw"):
            thisComponent.setAutoDraw(False)
    loop4.addData('fixation4.started', fixation4.tStartRefresh)
    loop4.addData('fixation4.stopped', fixation4.tStopRefresh)
    loop4.addData('stims4.started', stims4.tStartRefresh)
    loop4.addData('stims4.stopped', stims4.tStopRefresh)
    # check responses
    if key_resp_5.keys in ['', [], None]:  # No response was made
        key_resp_5.keys = None
        # was no response the correct answer?!
        if str(correct_key4).lower() == 'none':
           key_resp_5.corr = 1;  # correct non-response
        else:
           key_resp_5.corr = 0;  # failed to respond (incorrectly)
    # store data for loop4 (TrialHandler)
    loop4.addData('key_resp_5.keys',key_resp_5.keys)
    loop4.addData('key_resp_5.corr', key_resp_5.corr)
    if key_resp_5.keys != None:  # we had a response
        loop4.addData('key_resp_5.rt', key_resp_5.rt)
    loop4.addData('key_resp_5.started', key_resp_5.tStartRefresh)
    loop4.addData('key_resp_5.stopped', key_resp_5.tStopRefresh)
    loop4.addData('mm1_2.started', mm1_2.tStartRefresh)
    loop4.addData('mm1_2.stopped', mm1_2.tStopRefresh)
    loop4.addData('FF1_2.started', FF1_2.tStartRefresh)
    loop4.addData('FF1_2.stopped', FF1_2.tStopRefresh)
    # the Routine "trialszs1" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset()
    thisExp.nextEntry()
    
# completed 2.0 repeats of 'loop4'


# ------Prepare to start Routine "instroduction5"-------
continueRoutine = True
# update component parameters for each repeat
key_resp_12.keys = []
key_resp_12.rt = []
_key_resp_12_allKeys = []
# keep track of which components have finished
instroduction5Components = [image5, key_resp_12]
for thisComponent in instroduction5Components:
    thisComponent.tStart = None
    thisComponent.tStop = None
    thisComponent.tStartRefresh = None
    thisComponent.tStopRefresh = None
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED
# reset timers
t = 0
_timeToFirstFrame = win.getFutureFlipTime(clock="now")
instroduction5Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
frameN = -1

# -------Run Routine "instroduction5"-------
while continueRoutine:
    # get current time
    t = instroduction5Clock.getTime()
    tThisFlip = win.getFutureFlipTime(clock=instroduction5Clock)
    tThisFlipGlobal = win.getFutureFlipTime(clock=None)
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    # *image5* updates
    if image5.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        image5.frameNStart = frameN  # exact frame index
        image5.tStart = t  # local t and not account for scr refresh
        image5.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(image5, 'tStartRefresh')  # time at next scr refresh
        image5.setAutoDraw(True)
    
    # *key_resp_12* updates
    waitOnFlip = False
    if key_resp_12.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        key_resp_12.frameNStart = frameN  # exact frame index
        key_resp_12.tStart = t  # local t and not account for scr refresh
        key_resp_12.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(key_resp_12, 'tStartRefresh')  # time at next scr refresh
        key_resp_12.status = STARTED
        # keyboard checking is just starting
        waitOnFlip = True
        win.callOnFlip(key_resp_12.clock.reset)  # t=0 on next screen flip
        win.callOnFlip(key_resp_12.clearEvents, eventType='keyboard')  # clear events on next screen flip
    if key_resp_12.status == STARTED and not waitOnFlip:
        theseKeys = key_resp_12.getKeys(keyList=['space'], waitRelease=False)
        _key_resp_12_allKeys.extend(theseKeys)
        if len(_key_resp_12_allKeys):
            key_resp_12.keys = _key_resp_12_allKeys[-1].name  # just the last key pressed
            key_resp_12.rt = _key_resp_12_allKeys[-1].rt
            # a response ends the routine
            continueRoutine = False
    
    # check for quit (typically the Esc key)
    if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
        core.quit()
    
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in instroduction5Components:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # refresh the screen
    if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
        win.flip()

# -------Ending Routine "instroduction5"-------
for thisComponent in instroduction5Components:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)
thisExp.addData('image5.started', image5.tStartRefresh)
thisExp.addData('image5.stopped', image5.tStopRefresh)
# check responses
if key_resp_12.keys in ['', [], None]:  # No response was made
    key_resp_12.keys = None
thisExp.addData('key_resp_12.keys',key_resp_12.keys)
if key_resp_12.keys != None:  # we had a response
    thisExp.addData('key_resp_12.rt', key_resp_12.rt)
thisExp.addData('key_resp_12.started', key_resp_12.tStartRefresh)
thisExp.addData('key_resp_12.stopped', key_resp_12.tStopRefresh)
thisExp.nextEntry()
# the Routine "instroduction5" was not non-slip safe, so reset the non-slip timer
routineTimer.reset()

# set up handler to look after randomisation of conditions etc
loop5 = data.TrialHandler(nReps=2.0, method='random', 
    extraInfo=expInfo, originPath=-1,
    trialList=data.importConditions('IAT_block5.xlsx'),
    seed=None, name='loop5')
thisExp.addLoop(loop5)  # add the loop to the experiment
thisLoop5 = loop5.trialList[0]  # so we can initialise stimuli with some values
# abbreviate parameter names if possible (e.g. rgb = thisLoop5.rgb)
if thisLoop5 != None:
    for paramName in thisLoop5:
        exec('{} = thisLoop5[paramName]'.format(paramName))

for thisLoop5 in loop5:
    currentLoop = loop5
    # abbreviate parameter names if possible (e.g. rgb = thisLoop5.rgb)
    if thisLoop5 != None:
        for paramName in thisLoop5:
            exec('{} = thisLoop5[paramName]'.format(paramName))
    
    # set up handler to look after randomisation of conditions etc
    repeatLoop5 = data.TrialHandler(nReps=5.0, method='random', 
        extraInfo=expInfo, originPath=-1,
        trialList=[None],
        seed=None, name='repeatLoop5')
    thisExp.addLoop(repeatLoop5)  # add the loop to the experiment
    thisRepeatLoop5 = repeatLoop5.trialList[0]  # so we can initialise stimuli with some values
    # abbreviate parameter names if possible (e.g. rgb = thisRepeatLoop5.rgb)
    if thisRepeatLoop5 != None:
        for paramName in thisRepeatLoop5:
            exec('{} = thisRepeatLoop5[paramName]'.format(paramName))
    
    for thisRepeatLoop5 in repeatLoop5:
        currentLoop = repeatLoop5
        # abbreviate parameter names if possible (e.g. rgb = thisRepeatLoop5.rgb)
        if thisRepeatLoop5 != None:
            for paramName in thisRepeatLoop5:
                exec('{} = thisRepeatLoop5[paramName]'.format(paramName))
        
        # ------Prepare to start Routine "reialsyundong2"-------
        continueRoutine = True
        # update component parameters for each repeat
        stims5.setText(stims55
)
        key_resp_6.keys = []
        key_resp_6.rt = []
        _key_resp_6_allKeys = []
        # keep track of which components have finished
        reialsyundong2Components = [fixation5, stims5, key_resp_6, sportfemale2, sportmale2]
        for thisComponent in reialsyundong2Components:
            thisComponent.tStart = None
            thisComponent.tStop = None
            thisComponent.tStartRefresh = None
            thisComponent.tStopRefresh = None
            if hasattr(thisComponent, 'status'):
                thisComponent.status = NOT_STARTED
        # reset timers
        t = 0
        _timeToFirstFrame = win.getFutureFlipTime(clock="now")
        reialsyundong2Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
        frameN = -1
        
        # -------Run Routine "reialsyundong2"-------
        while continueRoutine:
            # get current time
            t = reialsyundong2Clock.getTime()
            tThisFlip = win.getFutureFlipTime(clock=reialsyundong2Clock)
            tThisFlipGlobal = win.getFutureFlipTime(clock=None)
            frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
            # update/draw components on each frame
            
            # *fixation5* updates
            if fixation5.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
                # keep track of start time/frame for later
                fixation5.frameNStart = frameN  # exact frame index
                fixation5.tStart = t  # local t and not account for scr refresh
                fixation5.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(fixation5, 'tStartRefresh')  # time at next scr refresh
                fixation5.setAutoDraw(True)
            if fixation5.status == STARTED:
                # is it time to stop? (based on global clock, using actual start)
                if tThisFlipGlobal > fixation5.tStartRefresh + 0.5-frameTolerance:
                    # keep track of stop time/frame for later
                    fixation5.tStop = t  # not accounting for scr refresh
                    fixation5.frameNStop = frameN  # exact frame index
                    win.timeOnFlip(fixation5, 'tStopRefresh')  # time at next scr refresh
                    fixation5.setAutoDraw(False)
            
            # *stims5* updates
            if stims5.status == NOT_STARTED and tThisFlip >= 0.5-frameTolerance:
                # keep track of start time/frame for later
                stims5.frameNStart = frameN  # exact frame index
                stims5.tStart = t  # local t and not account for scr refresh
                stims5.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(stims5, 'tStartRefresh')  # time at next scr refresh
                stims5.setAutoDraw(True)
            
            # *key_resp_6* updates
            waitOnFlip = False
            if key_resp_6.status == NOT_STARTED and tThisFlip >= 0.5-frameTolerance:
                # keep track of start time/frame for later
                key_resp_6.frameNStart = frameN  # exact frame index
                key_resp_6.tStart = t  # local t and not account for scr refresh
                key_resp_6.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(key_resp_6, 'tStartRefresh')  # time at next scr refresh
                key_resp_6.status = STARTED
                # keyboard checking is just starting
                waitOnFlip = True
                win.callOnFlip(key_resp_6.clock.reset)  # t=0 on next screen flip
                win.callOnFlip(key_resp_6.clearEvents, eventType='keyboard')  # clear events on next screen flip
            if key_resp_6.status == STARTED and not waitOnFlip:
                theseKeys = key_resp_6.getKeys(keyList=['e', 'i'], waitRelease=False)
                _key_resp_6_allKeys.extend(theseKeys)
                if len(_key_resp_6_allKeys):
                    key_resp_6.keys = _key_resp_6_allKeys[-1].name  # just the last key pressed
                    key_resp_6.rt = _key_resp_6_allKeys[-1].rt
                    # was this correct?
                    if (key_resp_6.keys == str(correct_key5)) or (key_resp_6.keys == correct_key5):
                        key_resp_6.corr = 1
                    else:
                        key_resp_6.corr = 0
                    # a response ends the routine
                    continueRoutine = False
            
            # *sportfemale2* updates
            if sportfemale2.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
                # keep track of start time/frame for later
                sportfemale2.frameNStart = frameN  # exact frame index
                sportfemale2.tStart = t  # local t and not account for scr refresh
                sportfemale2.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(sportfemale2, 'tStartRefresh')  # time at next scr refresh
                sportfemale2.setAutoDraw(True)
            
            # *sportmale2* updates
            if sportmale2.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
                # keep track of start time/frame for later
                sportmale2.frameNStart = frameN  # exact frame index
                sportmale2.tStart = t  # local t and not account for scr refresh
                sportmale2.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(sportmale2, 'tStartRefresh')  # time at next scr refresh
                sportmale2.setAutoDraw(True)
            
            # check for quit (typically the Esc key)
            if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
                core.quit()
            
            # check if all components have finished
            if not continueRoutine:  # a component has requested a forced-end of Routine
                break
            continueRoutine = False  # will revert to True if at least one component still running
            for thisComponent in reialsyundong2Components:
                if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
                    continueRoutine = True
                    break  # at least one component has not yet finished
            
            # refresh the screen
            if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
                win.flip()
        
        # -------Ending Routine "reialsyundong2"-------
        for thisComponent in reialsyundong2Components:
            if hasattr(thisComponent, "setAutoDraw"):
                thisComponent.setAutoDraw(False)
        repeatLoop5.addData('fixation5.started', fixation5.tStartRefresh)
        repeatLoop5.addData('fixation5.stopped', fixation5.tStopRefresh)
        repeatLoop5.addData('stims5.started', stims5.tStartRefresh)
        repeatLoop5.addData('stims5.stopped', stims5.tStopRefresh)
        # check responses
        if key_resp_6.keys in ['', [], None]:  # No response was made
            key_resp_6.keys = None
            # was no response the correct answer?!
            if str(correct_key5).lower() == 'none':
               key_resp_6.corr = 1;  # correct non-response
            else:
               key_resp_6.corr = 0;  # failed to respond (incorrectly)
        # store data for repeatLoop5 (TrialHandler)
        repeatLoop5.addData('key_resp_6.keys',key_resp_6.keys)
        repeatLoop5.addData('key_resp_6.corr', key_resp_6.corr)
        if key_resp_6.keys != None:  # we had a response
            repeatLoop5.addData('key_resp_6.rt', key_resp_6.rt)
        repeatLoop5.addData('key_resp_6.started', key_resp_6.tStartRefresh)
        repeatLoop5.addData('key_resp_6.stopped', key_resp_6.tStopRefresh)
        repeatLoop5.addData('sportfemale2.started', sportfemale2.tStartRefresh)
        repeatLoop5.addData('sportfemale2.stopped', sportfemale2.tStopRefresh)
        repeatLoop5.addData('sportmale2.started', sportmale2.tStartRefresh)
        repeatLoop5.addData('sportmale2.stopped', sportmale2.tStopRefresh)
        # the Routine "reialsyundong2" was not non-slip safe, so reset the non-slip timer
        routineTimer.reset()
        
        # ------Prepare to start Routine "restart_5"-------
        continueRoutine = True
        # update component parameters for each repeat
        if key_resp_6.corr==0:
           repeatLoop5.finished = False
        else:
            repeatLoop5.finished = True
        # keep track of which components have finished
        restart_5Components = []
        for thisComponent in restart_5Components:
            thisComponent.tStart = None
            thisComponent.tStop = None
            thisComponent.tStartRefresh = None
            thisComponent.tStopRefresh = None
            if hasattr(thisComponent, 'status'):
                thisComponent.status = NOT_STARTED
        # reset timers
        t = 0
        _timeToFirstFrame = win.getFutureFlipTime(clock="now")
        restart_5Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
        frameN = -1
        
        # -------Run Routine "restart_5"-------
        while continueRoutine:
            # get current time
            t = restart_5Clock.getTime()
            tThisFlip = win.getFutureFlipTime(clock=restart_5Clock)
            tThisFlipGlobal = win.getFutureFlipTime(clock=None)
            frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
            # update/draw components on each frame
            
            # check for quit (typically the Esc key)
            if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
                core.quit()
            
            # check if all components have finished
            if not continueRoutine:  # a component has requested a forced-end of Routine
                break
            continueRoutine = False  # will revert to True if at least one component still running
            for thisComponent in restart_5Components:
                if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
                    continueRoutine = True
                    break  # at least one component has not yet finished
            
            # refresh the screen
            if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
                win.flip()
        
        # -------Ending Routine "restart_5"-------
        for thisComponent in restart_5Components:
            if hasattr(thisComponent, "setAutoDraw"):
                thisComponent.setAutoDraw(False)
        # the Routine "restart_5" was not non-slip safe, so reset the non-slip timer
        routineTimer.reset()
        
        # ------Prepare to start Routine "feedback5"-------
        continueRoutine = True
        routineTimer.add(1.000000)
        # update component parameters for each repeat
        if correct_key5 == key_resp_6.keys  :
            feedback_text = ""
        elif correct_key5 != key_resp_6.keys  :
            feedback_text = "❌"
        text2_4.setText(feedback_text)
        # keep track of which components have finished
        feedback5Components = [text2_4]
        for thisComponent in feedback5Components:
            thisComponent.tStart = None
            thisComponent.tStop = None
            thisComponent.tStartRefresh = None
            thisComponent.tStopRefresh = None
            if hasattr(thisComponent, 'status'):
                thisComponent.status = NOT_STARTED
        # reset timers
        t = 0
        _timeToFirstFrame = win.getFutureFlipTime(clock="now")
        feedback5Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
        frameN = -1
        
        # -------Run Routine "feedback5"-------
        while continueRoutine and routineTimer.getTime() > 0:
            # get current time
            t = feedback5Clock.getTime()
            tThisFlip = win.getFutureFlipTime(clock=feedback5Clock)
            tThisFlipGlobal = win.getFutureFlipTime(clock=None)
            frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
            # update/draw components on each frame
            
            # *text2_4* updates
            if text2_4.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
                # keep track of start time/frame for later
                text2_4.frameNStart = frameN  # exact frame index
                text2_4.tStart = t  # local t and not account for scr refresh
                text2_4.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(text2_4, 'tStartRefresh')  # time at next scr refresh
                text2_4.setAutoDraw(True)
            if text2_4.status == STARTED:
                # is it time to stop? (based on global clock, using actual start)
                if tThisFlipGlobal > text2_4.tStartRefresh + 1.0-frameTolerance:
                    # keep track of stop time/frame for later
                    text2_4.tStop = t  # not accounting for scr refresh
                    text2_4.frameNStop = frameN  # exact frame index
                    win.timeOnFlip(text2_4, 'tStopRefresh')  # time at next scr refresh
                    text2_4.setAutoDraw(False)
            
            # check for quit (typically the Esc key)
            if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
                core.quit()
            
            # check if all components have finished
            if not continueRoutine:  # a component has requested a forced-end of Routine
                break
            continueRoutine = False  # will revert to True if at least one component still running
            for thisComponent in feedback5Components:
                if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
                    continueRoutine = True
                    break  # at least one component has not yet finished
            
            # refresh the screen
            if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
                win.flip()
        
        # -------Ending Routine "feedback5"-------
        for thisComponent in feedback5Components:
            if hasattr(thisComponent, "setAutoDraw"):
                thisComponent.setAutoDraw(False)
        repeatLoop5.addData('text2_4.started', text2_4.tStartRefresh)
        repeatLoop5.addData('text2_4.stopped', text2_4.tStopRefresh)
        thisExp.nextEntry()
        
    # completed 5.0 repeats of 'repeatLoop5'
    
    thisExp.nextEntry()
    
# completed 2.0 repeats of 'loop5'


# ------Prepare to start Routine "instruction6"-------
continueRoutine = True
# update component parameters for each repeat
key_resp_13.keys = []
key_resp_13.rt = []
_key_resp_13_allKeys = []
# keep track of which components have finished
instruction6Components = [image6, key_resp_13]
for thisComponent in instruction6Components:
    thisComponent.tStart = None
    thisComponent.tStop = None
    thisComponent.tStartRefresh = None
    thisComponent.tStopRefresh = None
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED
# reset timers
t = 0
_timeToFirstFrame = win.getFutureFlipTime(clock="now")
instruction6Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
frameN = -1

# -------Run Routine "instruction6"-------
while continueRoutine:
    # get current time
    t = instruction6Clock.getTime()
    tThisFlip = win.getFutureFlipTime(clock=instruction6Clock)
    tThisFlipGlobal = win.getFutureFlipTime(clock=None)
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    # *image6* updates
    if image6.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        image6.frameNStart = frameN  # exact frame index
        image6.tStart = t  # local t and not account for scr refresh
        image6.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(image6, 'tStartRefresh')  # time at next scr refresh
        image6.setAutoDraw(True)
    
    # *key_resp_13* updates
    waitOnFlip = False
    if key_resp_13.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        key_resp_13.frameNStart = frameN  # exact frame index
        key_resp_13.tStart = t  # local t and not account for scr refresh
        key_resp_13.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(key_resp_13, 'tStartRefresh')  # time at next scr refresh
        key_resp_13.status = STARTED
        # keyboard checking is just starting
        waitOnFlip = True
        win.callOnFlip(key_resp_13.clock.reset)  # t=0 on next screen flip
        win.callOnFlip(key_resp_13.clearEvents, eventType='keyboard')  # clear events on next screen flip
    if key_resp_13.status == STARTED and not waitOnFlip:
        theseKeys = key_resp_13.getKeys(keyList=['space'], waitRelease=False)
        _key_resp_13_allKeys.extend(theseKeys)
        if len(_key_resp_13_allKeys):
            key_resp_13.keys = _key_resp_13_allKeys[-1].name  # just the last key pressed
            key_resp_13.rt = _key_resp_13_allKeys[-1].rt
            # a response ends the routine
            continueRoutine = False
    
    # check for quit (typically the Esc key)
    if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
        core.quit()
    
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in instruction6Components:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # refresh the screen
    if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
        win.flip()

# -------Ending Routine "instruction6"-------
for thisComponent in instruction6Components:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)
thisExp.addData('image6.started', image6.tStartRefresh)
thisExp.addData('image6.stopped', image6.tStopRefresh)
# check responses
if key_resp_13.keys in ['', [], None]:  # No response was made
    key_resp_13.keys = None
thisExp.addData('key_resp_13.keys',key_resp_13.keys)
if key_resp_13.keys != None:  # we had a response
    thisExp.addData('key_resp_13.rt', key_resp_13.rt)
thisExp.addData('key_resp_13.started', key_resp_13.tStartRefresh)
thisExp.addData('key_resp_13.stopped', key_resp_13.tStopRefresh)
thisExp.nextEntry()
# the Routine "instruction6" was not non-slip safe, so reset the non-slip timer
routineTimer.reset()

# set up handler to look after randomisation of conditions etc
loop6 = data.TrialHandler(nReps=2.0, method='random', 
    extraInfo=expInfo, originPath=-1,
    trialList=data.importConditions('IAT_block6.xlsx'),
    seed=None, name='loop6')
thisExp.addLoop(loop6)  # add the loop to the experiment
thisLoop6 = loop6.trialList[0]  # so we can initialise stimuli with some values
# abbreviate parameter names if possible (e.g. rgb = thisLoop6.rgb)
if thisLoop6 != None:
    for paramName in thisLoop6:
        exec('{} = thisLoop6[paramName]'.format(paramName))

for thisLoop6 in loop6:
    currentLoop = loop6
    # abbreviate parameter names if possible (e.g. rgb = thisLoop6.rgb)
    if thisLoop6 != None:
        for paramName in thisLoop6:
            exec('{} = thisLoop6[paramName]'.format(paramName))
    
    # set up handler to look after randomisation of conditions etc
    repeatLoop6 = data.TrialHandler(nReps=5.0, method='random', 
        extraInfo=expInfo, originPath=-1,
        trialList=[None],
        seed=None, name='repeatLoop6')
    thisExp.addLoop(repeatLoop6)  # add the loop to the experiment
    thisRepeatLoop6 = repeatLoop6.trialList[0]  # so we can initialise stimuli with some values
    # abbreviate parameter names if possible (e.g. rgb = thisRepeatLoop6.rgb)
    if thisRepeatLoop6 != None:
        for paramName in thisRepeatLoop6:
            exec('{} = thisRepeatLoop6[paramName]'.format(paramName))
    
    for thisRepeatLoop6 in repeatLoop6:
        currentLoop = repeatLoop6
        # abbreviate parameter names if possible (e.g. rgb = thisRepeatLoop6.rgb)
        if thisRepeatLoop6 != None:
            for paramName in thisRepeatLoop6:
                exec('{} = thisRepeatLoop6[paramName]'.format(paramName))
        
        # ------Prepare to start Routine "trialspr2"-------
        continueRoutine = True
        # update component parameters for each repeat
        stims6.setText(stims66)
        key_resp_7.keys = []
        key_resp_7.rt = []
        _key_resp_7_allKeys = []
        # keep track of which components have finished
        trialspr2Components = [fixation6, stims6, key_resp_7, FM, MF]
        for thisComponent in trialspr2Components:
            thisComponent.tStart = None
            thisComponent.tStop = None
            thisComponent.tStartRefresh = None
            thisComponent.tStopRefresh = None
            if hasattr(thisComponent, 'status'):
                thisComponent.status = NOT_STARTED
        # reset timers
        t = 0
        _timeToFirstFrame = win.getFutureFlipTime(clock="now")
        trialspr2Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
        frameN = -1
        
        # -------Run Routine "trialspr2"-------
        while continueRoutine:
            # get current time
            t = trialspr2Clock.getTime()
            tThisFlip = win.getFutureFlipTime(clock=trialspr2Clock)
            tThisFlipGlobal = win.getFutureFlipTime(clock=None)
            frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
            # update/draw components on each frame
            
            # *fixation6* updates
            if fixation6.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
                # keep track of start time/frame for later
                fixation6.frameNStart = frameN  # exact frame index
                fixation6.tStart = t  # local t and not account for scr refresh
                fixation6.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(fixation6, 'tStartRefresh')  # time at next scr refresh
                fixation6.setAutoDraw(True)
            if fixation6.status == STARTED:
                # is it time to stop? (based on global clock, using actual start)
                if tThisFlipGlobal > fixation6.tStartRefresh + 0.5-frameTolerance:
                    # keep track of stop time/frame for later
                    fixation6.tStop = t  # not accounting for scr refresh
                    fixation6.frameNStop = frameN  # exact frame index
                    win.timeOnFlip(fixation6, 'tStopRefresh')  # time at next scr refresh
                    fixation6.setAutoDraw(False)
            
            # *stims6* updates
            if stims6.status == NOT_STARTED and tThisFlip >= 0.5-frameTolerance:
                # keep track of start time/frame for later
                stims6.frameNStart = frameN  # exact frame index
                stims6.tStart = t  # local t and not account for scr refresh
                stims6.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(stims6, 'tStartRefresh')  # time at next scr refresh
                stims6.setAutoDraw(True)
            
            # *key_resp_7* updates
            waitOnFlip = False
            if key_resp_7.status == NOT_STARTED and tThisFlip >= 0.5-frameTolerance:
                # keep track of start time/frame for later
                key_resp_7.frameNStart = frameN  # exact frame index
                key_resp_7.tStart = t  # local t and not account for scr refresh
                key_resp_7.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(key_resp_7, 'tStartRefresh')  # time at next scr refresh
                key_resp_7.status = STARTED
                # keyboard checking is just starting
                waitOnFlip = True
                win.callOnFlip(key_resp_7.clock.reset)  # t=0 on next screen flip
                win.callOnFlip(key_resp_7.clearEvents, eventType='keyboard')  # clear events on next screen flip
            if key_resp_7.status == STARTED and not waitOnFlip:
                theseKeys = key_resp_7.getKeys(keyList=['e', 'i'], waitRelease=False)
                _key_resp_7_allKeys.extend(theseKeys)
                if len(_key_resp_7_allKeys):
                    key_resp_7.keys = _key_resp_7_allKeys[-1].name  # just the last key pressed
                    key_resp_7.rt = _key_resp_7_allKeys[-1].rt
                    # was this correct?
                    if (key_resp_7.keys == str(correct_key6)) or (key_resp_7.keys == correct_key6):
                        key_resp_7.corr = 1
                    else:
                        key_resp_7.corr = 0
                    # a response ends the routine
                    continueRoutine = False
            
            # *FM* updates
            if FM.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
                # keep track of start time/frame for later
                FM.frameNStart = frameN  # exact frame index
                FM.tStart = t  # local t and not account for scr refresh
                FM.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(FM, 'tStartRefresh')  # time at next scr refresh
                FM.setAutoDraw(True)
            
            # *MF* updates
            if MF.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
                # keep track of start time/frame for later
                MF.frameNStart = frameN  # exact frame index
                MF.tStart = t  # local t and not account for scr refresh
                MF.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(MF, 'tStartRefresh')  # time at next scr refresh
                MF.setAutoDraw(True)
            
            # check for quit (typically the Esc key)
            if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
                core.quit()
            
            # check if all components have finished
            if not continueRoutine:  # a component has requested a forced-end of Routine
                break
            continueRoutine = False  # will revert to True if at least one component still running
            for thisComponent in trialspr2Components:
                if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
                    continueRoutine = True
                    break  # at least one component has not yet finished
            
            # refresh the screen
            if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
                win.flip()
        
        # -------Ending Routine "trialspr2"-------
        for thisComponent in trialspr2Components:
            if hasattr(thisComponent, "setAutoDraw"):
                thisComponent.setAutoDraw(False)
        repeatLoop6.addData('fixation6.started', fixation6.tStartRefresh)
        repeatLoop6.addData('fixation6.stopped', fixation6.tStopRefresh)
        repeatLoop6.addData('stims6.started', stims6.tStartRefresh)
        repeatLoop6.addData('stims6.stopped', stims6.tStopRefresh)
        # check responses
        if key_resp_7.keys in ['', [], None]:  # No response was made
            key_resp_7.keys = None
            # was no response the correct answer?!
            if str(correct_key6).lower() == 'none':
               key_resp_7.corr = 1;  # correct non-response
            else:
               key_resp_7.corr = 0;  # failed to respond (incorrectly)
        # store data for repeatLoop6 (TrialHandler)
        repeatLoop6.addData('key_resp_7.keys',key_resp_7.keys)
        repeatLoop6.addData('key_resp_7.corr', key_resp_7.corr)
        if key_resp_7.keys != None:  # we had a response
            repeatLoop6.addData('key_resp_7.rt', key_resp_7.rt)
        repeatLoop6.addData('key_resp_7.started', key_resp_7.tStartRefresh)
        repeatLoop6.addData('key_resp_7.stopped', key_resp_7.tStopRefresh)
        repeatLoop6.addData('FM.started', FM.tStartRefresh)
        repeatLoop6.addData('FM.stopped', FM.tStopRefresh)
        repeatLoop6.addData('MF.started', MF.tStartRefresh)
        repeatLoop6.addData('MF.stopped', MF.tStopRefresh)
        # the Routine "trialspr2" was not non-slip safe, so reset the non-slip timer
        routineTimer.reset()
        
        # ------Prepare to start Routine "restart_trial6"-------
        continueRoutine = True
        # update component parameters for each repeat
        if key_resp_7.corr==0:
           repeatLoop6.finished = False
        else:
            repeatLoop6.finished = True
        # keep track of which components have finished
        restart_trial6Components = []
        for thisComponent in restart_trial6Components:
            thisComponent.tStart = None
            thisComponent.tStop = None
            thisComponent.tStartRefresh = None
            thisComponent.tStopRefresh = None
            if hasattr(thisComponent, 'status'):
                thisComponent.status = NOT_STARTED
        # reset timers
        t = 0
        _timeToFirstFrame = win.getFutureFlipTime(clock="now")
        restart_trial6Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
        frameN = -1
        
        # -------Run Routine "restart_trial6"-------
        while continueRoutine:
            # get current time
            t = restart_trial6Clock.getTime()
            tThisFlip = win.getFutureFlipTime(clock=restart_trial6Clock)
            tThisFlipGlobal = win.getFutureFlipTime(clock=None)
            frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
            # update/draw components on each frame
            
            # check for quit (typically the Esc key)
            if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
                core.quit()
            
            # check if all components have finished
            if not continueRoutine:  # a component has requested a forced-end of Routine
                break
            continueRoutine = False  # will revert to True if at least one component still running
            for thisComponent in restart_trial6Components:
                if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
                    continueRoutine = True
                    break  # at least one component has not yet finished
            
            # refresh the screen
            if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
                win.flip()
        
        # -------Ending Routine "restart_trial6"-------
        for thisComponent in restart_trial6Components:
            if hasattr(thisComponent, "setAutoDraw"):
                thisComponent.setAutoDraw(False)
        # the Routine "restart_trial6" was not non-slip safe, so reset the non-slip timer
        routineTimer.reset()
        
        # ------Prepare to start Routine "feedback6"-------
        continueRoutine = True
        routineTimer.add(1.000000)
        # update component parameters for each repeat
        if correct_key6 == key_resp_7.keys  :
            feedback_text = ""
        elif correct_key6 != key_resp_7.keys  :
            feedback_text = "❌"
        text2_5.setText(feedback_text)
        # keep track of which components have finished
        feedback6Components = [text2_5]
        for thisComponent in feedback6Components:
            thisComponent.tStart = None
            thisComponent.tStop = None
            thisComponent.tStartRefresh = None
            thisComponent.tStopRefresh = None
            if hasattr(thisComponent, 'status'):
                thisComponent.status = NOT_STARTED
        # reset timers
        t = 0
        _timeToFirstFrame = win.getFutureFlipTime(clock="now")
        feedback6Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
        frameN = -1
        
        # -------Run Routine "feedback6"-------
        while continueRoutine and routineTimer.getTime() > 0:
            # get current time
            t = feedback6Clock.getTime()
            tThisFlip = win.getFutureFlipTime(clock=feedback6Clock)
            tThisFlipGlobal = win.getFutureFlipTime(clock=None)
            frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
            # update/draw components on each frame
            
            # *text2_5* updates
            if text2_5.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
                # keep track of start time/frame for later
                text2_5.frameNStart = frameN  # exact frame index
                text2_5.tStart = t  # local t and not account for scr refresh
                text2_5.tStartRefresh = tThisFlipGlobal  # on global time
                win.timeOnFlip(text2_5, 'tStartRefresh')  # time at next scr refresh
                text2_5.setAutoDraw(True)
            if text2_5.status == STARTED:
                # is it time to stop? (based on global clock, using actual start)
                if tThisFlipGlobal > text2_5.tStartRefresh + 1.0-frameTolerance:
                    # keep track of stop time/frame for later
                    text2_5.tStop = t  # not accounting for scr refresh
                    text2_5.frameNStop = frameN  # exact frame index
                    win.timeOnFlip(text2_5, 'tStopRefresh')  # time at next scr refresh
                    text2_5.setAutoDraw(False)
            
            # check for quit (typically the Esc key)
            if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
                core.quit()
            
            # check if all components have finished
            if not continueRoutine:  # a component has requested a forced-end of Routine
                break
            continueRoutine = False  # will revert to True if at least one component still running
            for thisComponent in feedback6Components:
                if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
                    continueRoutine = True
                    break  # at least one component has not yet finished
            
            # refresh the screen
            if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
                win.flip()
        
        # -------Ending Routine "feedback6"-------
        for thisComponent in feedback6Components:
            if hasattr(thisComponent, "setAutoDraw"):
                thisComponent.setAutoDraw(False)
        repeatLoop6.addData('text2_5.started', text2_5.tStartRefresh)
        repeatLoop6.addData('text2_5.stopped', text2_5.tStopRefresh)
        thisExp.nextEntry()
        
    # completed 5.0 repeats of 'repeatLoop6'
    
    thisExp.nextEntry()
    
# completed 2.0 repeats of 'loop6'


# ------Prepare to start Routine "instruction7"-------
continueRoutine = True
# update component parameters for each repeat
key_resp_14.keys = []
key_resp_14.rt = []
_key_resp_14_allKeys = []
# keep track of which components have finished
instruction7Components = [image7, key_resp_14]
for thisComponent in instruction7Components:
    thisComponent.tStart = None
    thisComponent.tStop = None
    thisComponent.tStartRefresh = None
    thisComponent.tStopRefresh = None
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED
# reset timers
t = 0
_timeToFirstFrame = win.getFutureFlipTime(clock="now")
instruction7Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
frameN = -1

# -------Run Routine "instruction7"-------
while continueRoutine:
    # get current time
    t = instruction7Clock.getTime()
    tThisFlip = win.getFutureFlipTime(clock=instruction7Clock)
    tThisFlipGlobal = win.getFutureFlipTime(clock=None)
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    # *image7* updates
    if image7.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        image7.frameNStart = frameN  # exact frame index
        image7.tStart = t  # local t and not account for scr refresh
        image7.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(image7, 'tStartRefresh')  # time at next scr refresh
        image7.setAutoDraw(True)
    
    # *key_resp_14* updates
    waitOnFlip = False
    if key_resp_14.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        key_resp_14.frameNStart = frameN  # exact frame index
        key_resp_14.tStart = t  # local t and not account for scr refresh
        key_resp_14.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(key_resp_14, 'tStartRefresh')  # time at next scr refresh
        key_resp_14.status = STARTED
        # keyboard checking is just starting
        waitOnFlip = True
        win.callOnFlip(key_resp_14.clock.reset)  # t=0 on next screen flip
        win.callOnFlip(key_resp_14.clearEvents, eventType='keyboard')  # clear events on next screen flip
    if key_resp_14.status == STARTED and not waitOnFlip:
        theseKeys = key_resp_14.getKeys(keyList=['space'], waitRelease=False)
        _key_resp_14_allKeys.extend(theseKeys)
        if len(_key_resp_14_allKeys):
            key_resp_14.keys = _key_resp_14_allKeys[-1].name  # just the last key pressed
            key_resp_14.rt = _key_resp_14_allKeys[-1].rt
            # a response ends the routine
            continueRoutine = False
    
    # check for quit (typically the Esc key)
    if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
        core.quit()
    
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in instruction7Components:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # refresh the screen
    if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
        win.flip()

# -------Ending Routine "instruction7"-------
for thisComponent in instruction7Components:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)
thisExp.addData('image7.started', image7.tStartRefresh)
thisExp.addData('image7.stopped', image7.tStopRefresh)
# check responses
if key_resp_14.keys in ['', [], None]:  # No response was made
    key_resp_14.keys = None
thisExp.addData('key_resp_14.keys',key_resp_14.keys)
if key_resp_14.keys != None:  # we had a response
    thisExp.addData('key_resp_14.rt', key_resp_14.rt)
thisExp.addData('key_resp_14.started', key_resp_14.tStartRefresh)
thisExp.addData('key_resp_14.stopped', key_resp_14.tStopRefresh)
thisExp.nextEntry()
# the Routine "instruction7" was not non-slip safe, so reset the non-slip timer
routineTimer.reset()

# set up handler to look after randomisation of conditions etc
loop7 = data.TrialHandler(nReps=2.0, method='random', 
    extraInfo=expInfo, originPath=-1,
    trialList=data.importConditions('IAT_block7.xlsx'),
    seed=None, name='loop7')
thisExp.addLoop(loop7)  # add the loop to the experiment
thisLoop7 = loop7.trialList[0]  # so we can initialise stimuli with some values
# abbreviate parameter names if possible (e.g. rgb = thisLoop7.rgb)
if thisLoop7 != None:
    for paramName in thisLoop7:
        exec('{} = thisLoop7[paramName]'.format(paramName))

for thisLoop7 in loop7:
    currentLoop = loop7
    # abbreviate parameter names if possible (e.g. rgb = thisLoop7.rgb)
    if thisLoop7 != None:
        for paramName in thisLoop7:
            exec('{} = thisLoop7[paramName]'.format(paramName))
    
    # ------Prepare to start Routine "trialszs2"-------
    continueRoutine = True
    # update component parameters for each repeat
    stims7.setText(stims77)
    key_resp_8.keys = []
    key_resp_8.rt = []
    _key_resp_8_allKeys = []
    # keep track of which components have finished
    trialszs2Components = [fixation7, stims7, key_resp_8, FM_2, MF_2]
    for thisComponent in trialszs2Components:
        thisComponent.tStart = None
        thisComponent.tStop = None
        thisComponent.tStartRefresh = None
        thisComponent.tStopRefresh = None
        if hasattr(thisComponent, 'status'):
            thisComponent.status = NOT_STARTED
    # reset timers
    t = 0
    _timeToFirstFrame = win.getFutureFlipTime(clock="now")
    trialszs2Clock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
    frameN = -1
    
    # -------Run Routine "trialszs2"-------
    while continueRoutine:
        # get current time
        t = trialszs2Clock.getTime()
        tThisFlip = win.getFutureFlipTime(clock=trialszs2Clock)
        tThisFlipGlobal = win.getFutureFlipTime(clock=None)
        frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
        # update/draw components on each frame
        
        # *fixation7* updates
        if fixation7.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
            # keep track of start time/frame for later
            fixation7.frameNStart = frameN  # exact frame index
            fixation7.tStart = t  # local t and not account for scr refresh
            fixation7.tStartRefresh = tThisFlipGlobal  # on global time
            win.timeOnFlip(fixation7, 'tStartRefresh')  # time at next scr refresh
            fixation7.setAutoDraw(True)
        if fixation7.status == STARTED:
            # is it time to stop? (based on global clock, using actual start)
            if tThisFlipGlobal > fixation7.tStartRefresh + 0.5-frameTolerance:
                # keep track of stop time/frame for later
                fixation7.tStop = t  # not accounting for scr refresh
                fixation7.frameNStop = frameN  # exact frame index
                win.timeOnFlip(fixation7, 'tStopRefresh')  # time at next scr refresh
                fixation7.setAutoDraw(False)
        
        # *stims7* updates
        if stims7.status == NOT_STARTED and tThisFlip >= 0.5-frameTolerance:
            # keep track of start time/frame for later
            stims7.frameNStart = frameN  # exact frame index
            stims7.tStart = t  # local t and not account for scr refresh
            stims7.tStartRefresh = tThisFlipGlobal  # on global time
            win.timeOnFlip(stims7, 'tStartRefresh')  # time at next scr refresh
            stims7.setAutoDraw(True)
        
        # *key_resp_8* updates
        waitOnFlip = False
        if key_resp_8.status == NOT_STARTED and tThisFlip >= 0.5-frameTolerance:
            # keep track of start time/frame for later
            key_resp_8.frameNStart = frameN  # exact frame index
            key_resp_8.tStart = t  # local t and not account for scr refresh
            key_resp_8.tStartRefresh = tThisFlipGlobal  # on global time
            win.timeOnFlip(key_resp_8, 'tStartRefresh')  # time at next scr refresh
            key_resp_8.status = STARTED
            # keyboard checking is just starting
            waitOnFlip = True
            win.callOnFlip(key_resp_8.clock.reset)  # t=0 on next screen flip
            win.callOnFlip(key_resp_8.clearEvents, eventType='keyboard')  # clear events on next screen flip
        if key_resp_8.status == STARTED and not waitOnFlip:
            theseKeys = key_resp_8.getKeys(keyList=['e', 'i'], waitRelease=False)
            _key_resp_8_allKeys.extend(theseKeys)
            if len(_key_resp_8_allKeys):
                key_resp_8.keys = _key_resp_8_allKeys[-1].name  # just the last key pressed
                key_resp_8.rt = _key_resp_8_allKeys[-1].rt
                # was this correct?
                if (key_resp_8.keys == str(correct_key7)) or (key_resp_8.keys == correct_key7):
                    key_resp_8.corr = 1
                else:
                    key_resp_8.corr = 0
                # a response ends the routine
                continueRoutine = False
        
        # *FM_2* updates
        if FM_2.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
            # keep track of start time/frame for later
            FM_2.frameNStart = frameN  # exact frame index
            FM_2.tStart = t  # local t and not account for scr refresh
            FM_2.tStartRefresh = tThisFlipGlobal  # on global time
            win.timeOnFlip(FM_2, 'tStartRefresh')  # time at next scr refresh
            FM_2.setAutoDraw(True)
        
        # *MF_2* updates
        if MF_2.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
            # keep track of start time/frame for later
            MF_2.frameNStart = frameN  # exact frame index
            MF_2.tStart = t  # local t and not account for scr refresh
            MF_2.tStartRefresh = tThisFlipGlobal  # on global time
            win.timeOnFlip(MF_2, 'tStartRefresh')  # time at next scr refresh
            MF_2.setAutoDraw(True)
        
        # check for quit (typically the Esc key)
        if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
            core.quit()
        
        # check if all components have finished
        if not continueRoutine:  # a component has requested a forced-end of Routine
            break
        continueRoutine = False  # will revert to True if at least one component still running
        for thisComponent in trialszs2Components:
            if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
                continueRoutine = True
                break  # at least one component has not yet finished
        
        # refresh the screen
        if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
            win.flip()
    
    # -------Ending Routine "trialszs2"-------
    for thisComponent in trialszs2Components:
        if hasattr(thisComponent, "setAutoDraw"):
            thisComponent.setAutoDraw(False)
    loop7.addData('fixation7.started', fixation7.tStartRefresh)
    loop7.addData('fixation7.stopped', fixation7.tStopRefresh)
    loop7.addData('stims7.started', stims7.tStartRefresh)
    loop7.addData('stims7.stopped', stims7.tStopRefresh)
    # check responses
    if key_resp_8.keys in ['', [], None]:  # No response was made
        key_resp_8.keys = None
        # was no response the correct answer?!
        if str(correct_key7).lower() == 'none':
           key_resp_8.corr = 1;  # correct non-response
        else:
           key_resp_8.corr = 0;  # failed to respond (incorrectly)
    # store data for loop7 (TrialHandler)
    loop7.addData('key_resp_8.keys',key_resp_8.keys)
    loop7.addData('key_resp_8.corr', key_resp_8.corr)
    if key_resp_8.keys != None:  # we had a response
        loop7.addData('key_resp_8.rt', key_resp_8.rt)
    loop7.addData('key_resp_8.started', key_resp_8.tStartRefresh)
    loop7.addData('key_resp_8.stopped', key_resp_8.tStopRefresh)
    loop7.addData('FM_2.started', FM_2.tStartRefresh)
    loop7.addData('FM_2.stopped', FM_2.tStopRefresh)
    loop7.addData('MF_2.started', MF_2.tStartRefresh)
    loop7.addData('MF_2.stopped', MF_2.tStopRefresh)
    # the Routine "trialszs2" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset()
    thisExp.nextEntry()
    
# completed 2.0 repeats of 'loop7'


# ------Prepare to start Routine "thanks"-------
continueRoutine = True
routineTimer.add(3.000000)
# update component parameters for each repeat
# keep track of which components have finished
thanksComponents = [imageend]
for thisComponent in thanksComponents:
    thisComponent.tStart = None
    thisComponent.tStop = None
    thisComponent.tStartRefresh = None
    thisComponent.tStopRefresh = None
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED
# reset timers
t = 0
_timeToFirstFrame = win.getFutureFlipTime(clock="now")
thanksClock.reset(-_timeToFirstFrame)  # t0 is time of first possible flip
frameN = -1

# -------Run Routine "thanks"-------
while continueRoutine and routineTimer.getTime() > 0:
    # get current time
    t = thanksClock.getTime()
    tThisFlip = win.getFutureFlipTime(clock=thanksClock)
    tThisFlipGlobal = win.getFutureFlipTime(clock=None)
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    # *imageend* updates
    if imageend.status == NOT_STARTED and tThisFlip >= 0.0-frameTolerance:
        # keep track of start time/frame for later
        imageend.frameNStart = frameN  # exact frame index
        imageend.tStart = t  # local t and not account for scr refresh
        imageend.tStartRefresh = tThisFlipGlobal  # on global time
        win.timeOnFlip(imageend, 'tStartRefresh')  # time at next scr refresh
        imageend.setAutoDraw(True)
    if imageend.status == STARTED:
        # is it time to stop? (based on global clock, using actual start)
        if tThisFlipGlobal > imageend.tStartRefresh + 3-frameTolerance:
            # keep track of stop time/frame for later
            imageend.tStop = t  # not accounting for scr refresh
            imageend.frameNStop = frameN  # exact frame index
            win.timeOnFlip(imageend, 'tStopRefresh')  # time at next scr refresh
            imageend.setAutoDraw(False)
    
    # check for quit (typically the Esc key)
    if endExpNow or defaultKeyboard.getKeys(keyList=["escape"]):
        core.quit()
    
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in thanksComponents:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # refresh the screen
    if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
        win.flip()

# -------Ending Routine "thanks"-------
for thisComponent in thanksComponents:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)
thisExp.addData('imageend.started', imageend.tStartRefresh)
thisExp.addData('imageend.stopped', imageend.tStopRefresh)

# Flip one final time so any remaining win.callOnFlip() 
# and win.timeOnFlip() tasks get executed before quitting
win.flip()

# these shouldn't be strictly necessary (should auto-save)
thisExp.saveAsWideText(filename+'.csv', delim='auto')
thisExp.saveAsPickle(filename)
logging.flush()
# make sure everything is closed down
thisExp.abort()  # or data files will save again on exit
win.close()
core.quit()
